/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.parser;

import com.android.tradefed.log.LogUtil;
import com.android.tradefed.util.brillopad.item.MemInfoItem;
import com.android.tradefed.util.brillopad.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemInfoParser
implements IParser {
    private static final Pattern INFO_LINE = Pattern.compile("^([^:]+):\\s+(\\d+) kB");

    @Override
    public MemInfoItem parse(List<String> block) {
        MemInfoItem item = new MemInfoItem();
        for (String line : block) {
            Matcher m = INFO_LINE.matcher(line);
            if (m.matches()) {
                String key = m.group(1);
                Integer value = Integer.parseInt(m.group(2));
                item.put(key, value);
                continue;
            }
            LogUtil.CLog.w("Failed to parse line '%s'", line);
        }
        return item;
    }
}

