/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.brillopad.parser;

import com.android.tradefed.util.brillopad.item.NativeCrashItem;
import com.android.tradefed.util.brillopad.parser.IParser;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeCrashParser
implements IParser {
    private static final Pattern START = Pattern.compile("^(?:\\*\\*\\* ){15}\\*\\*\\*$");
    private static final Pattern FINGERPRINT = Pattern.compile("^Build fingerprint: '(.*)'$");
    private static final Pattern APP = Pattern.compile("^pid: \\d+, tid: \\d+(, name: \\S+)?  >>> (\\S+) <<<$");

    @Override
    public NativeCrashItem parse(List<String> lines) {
        NativeCrashItem nc = null;
        StringBuilder stack = new StringBuilder();
        for (String line : lines) {
            Matcher m = START.matcher(line);
            if (m.matches()) {
                nc = new NativeCrashItem();
            }
            if (nc == null) continue;
            m = FINGERPRINT.matcher(line);
            if (m.matches()) {
                nc.setFingerprint(m.group(1));
            }
            if ((m = APP.matcher(line)).matches()) {
                nc.setApp(m.group(2));
            }
            stack.append(line);
            stack.append("\n");
        }
        if (nc != null) {
            nc.setStack(stack.toString().trim());
        }
        return nc;
    }
}

