/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.util.net;

import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.kxml2.io.KXmlSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcHelper {
    public static final String TRUE_VAL = "1";
    public static final String FALSE_VAL = "0";

    public static void writeOpenMethodCall(KXmlSerializer serializer, String ns, String name) throws IOException {
        serializer.startTag(ns, "methodCall");
        serializer.startTag(ns, "methodName");
        serializer.text(name);
        serializer.endTag(ns, "methodName");
        serializer.startTag(ns, "params");
    }

    public static void writeCloseMethodCall(KXmlSerializer serializer, String ns) throws IOException {
        serializer.endTag(ns, "params");
        serializer.endTag(ns, "methodCall");
    }

    public static void writeOpenMethodArg(KXmlSerializer serializer, String ns, String valueType) throws IOException {
        serializer.startTag(ns, "param");
        serializer.startTag(ns, "value");
        serializer.startTag(ns, valueType);
    }

    public static void writeCloseMethodArg(KXmlSerializer serializer, String ns, String valueType) throws IOException {
        serializer.endTag(ns, valueType);
        serializer.endTag(ns, "value");
        serializer.endTag(ns, "param");
    }

    public static void writeFullMethodArg(KXmlSerializer serializer, String ns, String valueType, String value) throws IOException {
        serializer.startTag(ns, "param");
        serializer.startTag(ns, valueType);
        serializer.text(value);
        serializer.endTag(ns, valueType);
        serializer.endTag(ns, "param");
    }

    public static void writeOpenStructMember(KXmlSerializer serializer, String ns, String name, String valueType) throws IOException {
        serializer.startTag(ns, "member");
        serializer.startTag(ns, "name");
        serializer.text(name);
        serializer.endTag(ns, "name");
        serializer.startTag(ns, "value");
        serializer.startTag(ns, valueType);
    }

    public static void writeCloseStructMember(KXmlSerializer serializer, String ns, String valueType) throws IOException {
        serializer.endTag(ns, valueType);
        serializer.endTag(ns, "value");
        serializer.endTag(ns, "member");
    }

    public static List<String> parseResponseTuple(InputStream input) {
        XmlRpcResponseParser parser = new XmlRpcResponseParser();
        try {
            parser.parse(input);
            return parser.getResponses();
        }
        catch (AbstractXmlParser.ParseException e) {
            System.err.format("got parse exception %s\n", e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XmlRpcResponseParser
    extends AbstractXmlParser {
        private RpcResponseHandler mHandler = new RpcResponseHandler();

        private XmlRpcResponseParser() {
        }

        @Override
        protected DefaultHandler createXmlHandler() {
            return this.mHandler;
        }

        public List<String> getResponses() {
            return this.mHandler.getResponses();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RpcResponseHandler
    extends DefaultHandler {
        private final List<String> mResponses = new LinkedList<String>();
        private String mType = null;
        private StringBuilder mValue = new StringBuilder();
        private boolean mInParams = false;
        private boolean mInValue = false;
        private static final String PARAMS_TAG = "params";
        private static final String VALUE_TAG = "value";
        private static final String PARAM_TAG = "param";

        private RpcResponseHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (!this.mInParams && !PARAMS_TAG.equals(localName)) {
                return;
            }
            if (PARAMS_TAG.equals(localName)) {
                this.mInParams = true;
                return;
            }
            if (VALUE_TAG.equals(localName) || PARAM_TAG.equals(localName)) {
                this.mInValue = true;
                return;
            }
            if (this.mInParams && this.mInValue) {
                this.mType = localName;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (PARAMS_TAG.equals(localName)) {
                this.mInParams = false;
            } else if (VALUE_TAG.equals(localName) || PARAM_TAG.equals(localName)) {
                this.mInValue = false;
            } else if (this.mType != null && this.mType.equals(localName)) {
                this.mResponses.add(this.mType);
                this.mResponses.add(this.mValue.toString());
                this.mType = null;
                this.mValue.delete(0, this.mValue.length());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mType == null) {
                return;
            }
            this.mValue.append(ch, start, length);
        }

        public List<String> getResponses() {
            return this.mResponses;
        }
    }
}

