/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class ArrayTable<R, C, V>
implements Table<R, C, V>,
Serializable {
    private final ImmutableList<R> rowList;
    private final ImmutableList<C> columnList;
    private final ImmutableMap<R, Integer> rowKeyToIndex;
    private final ImmutableMap<C, Integer> columnKeyToIndex;
    private final V[][] array;
    private transient CellSet cellSet;
    private transient ColumnMap columnMap;
    private transient RowMap rowMap;
    private transient Collection<V> values;
    private static final long serialVersionUID = 0L;

    public static <R, C, V> ArrayTable<R, C, V> create(Iterable<? extends R> iterable, Iterable<? extends C> iterable2) {
        return new ArrayTable<R, C, V>(iterable, iterable2);
    }

    public static <R, C, V> ArrayTable<R, C, V> create(Table<R, C, V> table) {
        return new ArrayTable<R, C, V>(table);
    }

    public static <R, C, V> ArrayTable<R, C, V> create(ArrayTable<R, C, V> arrayTable) {
        return new ArrayTable<R, C, V>(arrayTable);
    }

    private ArrayTable(Iterable<? extends R> iterable, Iterable<? extends C> iterable2) {
        this.rowList = ImmutableList.copyOf(iterable);
        this.columnList = ImmutableList.copyOf(iterable2);
        Preconditions.checkArgument(!this.rowList.isEmpty());
        Preconditions.checkArgument(!this.columnList.isEmpty());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < this.rowList.size(); ++i) {
            builder.put(this.rowList.get(i), i);
        }
        this.rowKeyToIndex = builder.build();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        for (int i = 0; i < this.columnList.size(); ++i) {
            builder2.put(this.columnList.get(i), i);
        }
        this.columnKeyToIndex = builder2.build();
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
    }

    private ArrayTable(Table<R, C, V> table) {
        this(table.rowKeySet(), table.columnKeySet());
        this.putAll(table);
    }

    private ArrayTable(ArrayTable<R, C, V> arrayTable) {
        this.rowList = arrayTable.rowList;
        this.columnList = arrayTable.columnList;
        this.rowKeyToIndex = arrayTable.rowKeyToIndex;
        this.columnKeyToIndex = arrayTable.columnKeyToIndex;
        Object[][] objectArray = new Object[this.rowList.size()][this.columnList.size()];
        this.array = objectArray;
        for (int i = 0; i < this.rowList.size(); ++i) {
            System.arraycopy(arrayTable.array[i], 0, objectArray[i], 0, arrayTable.array[i].length);
        }
    }

    public ImmutableList<R> rowKeyList() {
        return this.rowList;
    }

    public ImmutableList<C> columnKeyList() {
        return this.columnList;
    }

    public V at(int n, int n2) {
        return this.array[n][n2];
    }

    public V set(int n, int n2, @Nullable V v) {
        V v2 = this.array[n][n2];
        this.array[n][n2] = v;
        return v2;
    }

    public V[][] toArray(Class<V> clazz) {
        Object[][] objectArray = (Object[][])Array.newInstance(clazz, this.rowList.size(), this.columnList.size());
        for (int i = 0; i < this.rowList.size(); ++i) {
            System.arraycopy(this.array[i], 0, objectArray[i], 0, this.array[i].length);
        }
        return objectArray;
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void eraseAll() {
        for (Object[] objectArray : this.array) {
            Arrays.fill(objectArray, null);
        }
    }

    @Override
    public boolean contains(@Nullable Object object, @Nullable Object object2) {
        return this.containsRow(object) && this.containsColumn(object2);
    }

    @Override
    public boolean containsColumn(@Nullable Object object) {
        return this.columnKeyToIndex.containsKey(object);
    }

    @Override
    public boolean containsRow(@Nullable Object object) {
        return this.rowKeyToIndex.containsKey(object);
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        V[][] VArray = this.array;
        int n = VArray.length;
        for (int i = 0; i < n; ++i) {
            V[] VArray2;
            for (V v : VArray2 = VArray[i]) {
                if (!Objects.equal(object, v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(@Nullable Object object, @Nullable Object object2) {
        Integer n = this.rowKeyToIndex.get(object);
        Integer n2 = this.columnKeyToIndex.get(object2);
        return this.getIndexed(n, n2);
    }

    private V getIndexed(Integer n, Integer n2) {
        return n == null || n2 == null ? null : (V)this.array[n][n2];
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V put(R r, C c, @Nullable V v) {
        Preconditions.checkNotNull(r);
        Preconditions.checkNotNull(c);
        Integer n = this.rowKeyToIndex.get(r);
        Preconditions.checkArgument(n != null, "Row %s not in %s", r, this.rowList);
        Integer n2 = this.columnKeyToIndex.get(c);
        Preconditions.checkArgument(n2 != null, "Column %s not in %s", c, this.columnList);
        return this.set(n, n2, v);
    }

    @Override
    public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        for (Table.Cell<R, C, V> cell : table.cellSet()) {
            this.put(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
        }
    }

    @Override
    @Deprecated
    public V remove(Object object, Object object2) {
        throw new UnsupportedOperationException();
    }

    public V erase(@Nullable Object object, @Nullable Object object2) {
        Integer n = this.rowKeyToIndex.get(object);
        Integer n2 = this.columnKeyToIndex.get(object2);
        if (n == null || n2 == null) {
            return null;
        }
        return this.set(n, n2, null);
    }

    @Override
    public int size() {
        return this.rowList.size() * this.columnList.size();
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Table) {
            Table table = (Table)object;
            return ((Object)this.cellSet()).equals(table.cellSet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.cellSet()).hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        CellSet cellSet = this.cellSet;
        return cellSet == null ? (this.cellSet = new CellSet()) : cellSet;
    }

    @Override
    public Map<R, V> column(C c) {
        Preconditions.checkNotNull(c);
        Integer n = this.columnKeyToIndex.get(c);
        return n == null ? ImmutableMap.of() : new Column(n);
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return this.columnKeyToIndex.keySet();
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap columnMap = this.columnMap;
        return columnMap == null ? (this.columnMap = new ColumnMap()) : columnMap;
    }

    @Override
    public Map<C, V> row(R r) {
        Preconditions.checkNotNull(r);
        Integer n = this.rowKeyToIndex.get(r);
        return n == null ? ImmutableMap.of() : new Row(n);
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return this.rowKeyToIndex.keySet();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        RowMap rowMap = this.rowMap;
        return rowMap == null ? (this.rowMap = new RowMap()) : rowMap;
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values == null ? (this.values = new Values()) : values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new AbstractIndexedListIterator<V>(this.size()){

                @Override
                protected V get(int n) {
                    int n2 = n / ArrayTable.this.columnList.size();
                    int n3 = n % ArrayTable.this.columnList.size();
                    return ArrayTable.this.array[n2][n3];
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return ArrayTable.this.containsValue(object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowMapEntrySet
    extends AbstractSet<Map.Entry<R, Map<C, V>>> {
        private RowMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<R, Map<C, V>>>(this.size()){

                @Override
                protected Map.Entry<R, Map<C, V>> get(int n) {
                    return Maps.immutableEntry(ArrayTable.this.rowList.get(n), new Row(n));
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.rowList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowMap
    extends AbstractMap<R, Map<C, V>> {
        transient RowMapEntrySet entrySet;

        private RowMap() {
        }

        @Override
        public Set<Map.Entry<R, Map<C, V>>> entrySet() {
            RowMapEntrySet rowMapEntrySet = this.entrySet;
            return rowMapEntrySet == null ? (this.entrySet = new RowMapEntrySet()) : rowMapEntrySet;
        }

        @Override
        public Map<C, V> get(Object object) {
            Integer n = (Integer)ArrayTable.this.rowKeyToIndex.get(object);
            return n == null ? null : new Row(n);
        }

        @Override
        public boolean containsKey(Object object) {
            return ArrayTable.this.containsRow(object);
        }

        @Override
        public Set<R> keySet() {
            return ArrayTable.this.rowKeySet();
        }

        @Override
        public Map<C, V> remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RowEntrySet
    extends AbstractSet<Map.Entry<C, V>> {
        final int rowIndex;

        RowEntrySet(int n) {
            this.rowIndex = n;
        }

        @Override
        public Iterator<Map.Entry<C, V>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<C, V>>(this.size()){

                @Override
                protected Map.Entry<C, V> get(final int n) {
                    return new AbstractMapEntry<C, V>(){

                        @Override
                        public C getKey() {
                            return ArrayTable.this.columnList.get(n);
                        }

                        @Override
                        public V getValue() {
                            return ArrayTable.this.array[RowEntrySet.this.rowIndex][n];
                        }

                        @Override
                        public V setValue(V v) {
                            return ArrayTable.this.set(RowEntrySet.this.rowIndex, n, v);
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.columnList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Row
    extends AbstractMap<C, V> {
        final int rowIndex;
        RowEntrySet entrySet;

        Row(int n) {
            this.rowIndex = n;
        }

        @Override
        public Set<Map.Entry<C, V>> entrySet() {
            RowEntrySet rowEntrySet = this.entrySet;
            return rowEntrySet == null ? (this.entrySet = new RowEntrySet(this.rowIndex)) : rowEntrySet;
        }

        @Override
        public V get(Object object) {
            Integer n = (Integer)ArrayTable.this.columnKeyToIndex.get(object);
            return ArrayTable.this.getIndexed(this.rowIndex, n);
        }

        @Override
        public boolean containsKey(Object object) {
            return ArrayTable.this.containsColumn(object);
        }

        @Override
        public V put(C c, V v) {
            Preconditions.checkNotNull(c);
            Integer n = (Integer)ArrayTable.this.columnKeyToIndex.get(c);
            Preconditions.checkArgument(n != null, "Column %s not in %s", c, ArrayTable.this.columnList);
            return ArrayTable.this.set(this.rowIndex, n, v);
        }

        @Override
        public Set<C> keySet() {
            return ArrayTable.this.columnKeySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnMapEntrySet
    extends AbstractSet<Map.Entry<C, Map<R, V>>> {
        private ColumnMapEntrySet() {
        }

        @Override
        public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<C, Map<R, V>>>(this.size()){

                @Override
                protected Map.Entry<C, Map<R, V>> get(int n) {
                    return Maps.immutableEntry(ArrayTable.this.columnList.get(n), new Column(n));
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.columnList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnMap
    extends AbstractMap<C, Map<R, V>> {
        transient ColumnMapEntrySet entrySet;

        private ColumnMap() {
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> entrySet() {
            ColumnMapEntrySet columnMapEntrySet = this.entrySet;
            return columnMapEntrySet == null ? (this.entrySet = new ColumnMapEntrySet()) : columnMapEntrySet;
        }

        @Override
        public Map<R, V> get(Object object) {
            Integer n = (Integer)ArrayTable.this.columnKeyToIndex.get(object);
            return n == null ? null : new Column(n);
        }

        @Override
        public boolean containsKey(Object object) {
            return ArrayTable.this.containsColumn(object);
        }

        @Override
        public Set<C> keySet() {
            return ArrayTable.this.columnKeySet();
        }

        @Override
        public Map<R, V> remove(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ColumnEntrySet
    extends AbstractSet<Map.Entry<R, V>> {
        final int columnIndex;

        ColumnEntrySet(int n) {
            this.columnIndex = n;
        }

        @Override
        public Iterator<Map.Entry<R, V>> iterator() {
            return new AbstractIndexedListIterator<Map.Entry<R, V>>(this.size()){

                @Override
                protected Map.Entry<R, V> get(final int n) {
                    return new AbstractMapEntry<R, V>(){

                        @Override
                        public R getKey() {
                            return ArrayTable.this.rowList.get(n);
                        }

                        @Override
                        public V getValue() {
                            return ArrayTable.this.array[n][ColumnEntrySet.this.columnIndex];
                        }

                        @Override
                        public V setValue(V v) {
                            return ArrayTable.this.set(n, ColumnEntrySet.this.columnIndex, v);
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.rowList.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Column
    extends AbstractMap<R, V> {
        final int columnIndex;
        ColumnEntrySet entrySet;

        Column(int n) {
            this.columnIndex = n;
        }

        @Override
        public Set<Map.Entry<R, V>> entrySet() {
            ColumnEntrySet columnEntrySet = this.entrySet;
            return columnEntrySet == null ? (this.entrySet = new ColumnEntrySet(this.columnIndex)) : columnEntrySet;
        }

        @Override
        public V get(Object object) {
            Integer n = (Integer)ArrayTable.this.rowKeyToIndex.get(object);
            return ArrayTable.this.getIndexed(n, this.columnIndex);
        }

        @Override
        public boolean containsKey(Object object) {
            return ArrayTable.this.rowKeyToIndex.containsKey(object);
        }

        @Override
        public V put(R r, V v) {
            Preconditions.checkNotNull(r);
            Integer n = (Integer)ArrayTable.this.rowKeyToIndex.get(r);
            Preconditions.checkArgument(n != null, "Row %s not in %s", r, ArrayTable.this.rowList);
            return ArrayTable.this.set(n, this.columnIndex, v);
        }

        @Override
        public Set<R> keySet() {
            return ArrayTable.this.rowKeySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellSet
    extends AbstractSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new AbstractIndexedListIterator<Table.Cell<R, C, V>>(this.size()){

                @Override
                protected Table.Cell<R, C, V> get(final int n) {
                    return new Tables.AbstractCell<R, C, V>(){
                        final int rowIndex;
                        final int columnIndex;
                        {
                            this.rowIndex = n / ArrayTable.this.columnList.size();
                            this.columnIndex = n % ArrayTable.this.columnList.size();
                        }

                        @Override
                        public R getRowKey() {
                            return ArrayTable.this.rowList.get(this.rowIndex);
                        }

                        @Override
                        public C getColumnKey() {
                            return ArrayTable.this.columnList.get(this.columnIndex);
                        }

                        @Override
                        public V getValue() {
                            return ArrayTable.this.array[this.rowIndex][this.columnIndex];
                        }
                    };
                }
            };
        }

        @Override
        public int size() {
            return ArrayTable.this.size();
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                Integer n = (Integer)ArrayTable.this.rowKeyToIndex.get(cell.getRowKey());
                Integer n2 = (Integer)ArrayTable.this.columnKeyToIndex.get(cell.getColumnKey());
                return n != null && n2 != null && Objects.equal(ArrayTable.this.array[n][n2], cell.getValue());
            }
            return false;
        }
    }
}

