/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends AbstractBiMap<K, V> {
    @GwtIncompatible(value="Not needed in emulated source")
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return new HashBiMap<K, V>();
    }

    public static <K, V> HashBiMap<K, V> create(int n) {
        return new HashBiMap<K, V>(n);
    }

    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        HashBiMap<K, V> hashBiMap = HashBiMap.create(map.size());
        hashBiMap.putAll((Map)map);
        return hashBiMap;
    }

    private HashBiMap() {
        super(new HashMap(), new HashMap());
    }

    private HashBiMap(int n) {
        super(Maps.newHashMapWithExpectedSize(n), Maps.newHashMapWithExpectedSize(n));
    }

    @Override
    public V put(@Nullable K k, @Nullable V v) {
        return super.put(k, v);
    }

    @Override
    public V forcePut(@Nullable K k, @Nullable V v) {
        return super.forcePut(k, v);
    }

    @GwtIncompatible(value="java.io.ObjectOutputStream")
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Serialization.writeMap(this, objectOutputStream);
    }

    @GwtIncompatible(value="java.io.ObjectInputStream")
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = Serialization.readCount(objectInputStream);
        this.setDelegates(Maps.newHashMapWithExpectedSize(n), Maps.newHashMapWithExpectedSize(n));
        Serialization.populateMap(this, objectInputStream, n);
    }
}

