/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.BoundType;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.Cut;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.EmptyContiguousSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Ranges;
import com.google.common.collect.RegularContiguousSet;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
@Beta
public final class Range<C extends Comparable>
implements Predicate<C>,
Serializable {
    final Cut<C> lowerBound;
    final Cut<C> upperBound;
    private static final long serialVersionUID = 0L;

    Range(Cut<C> cut, Cut<C> cut2) {
        if (cut.compareTo(cut2) > 0) {
            throw new IllegalArgumentException("Invalid range: " + Range.toString(cut, cut2));
        }
        this.lowerBound = cut;
        this.upperBound = cut2;
    }

    public boolean hasLowerBound() {
        return this.lowerBound != Cut.belowAll();
    }

    public C lowerEndpoint() {
        return this.lowerBound.endpoint();
    }

    public BoundType lowerBoundType() {
        return this.lowerBound.typeAsLowerBound();
    }

    public boolean hasUpperBound() {
        return this.upperBound != Cut.aboveAll();
    }

    public C upperEndpoint() {
        return this.upperBound.endpoint();
    }

    public BoundType upperBoundType() {
        return this.upperBound.typeAsUpperBound();
    }

    public boolean isEmpty() {
        return this.lowerBound.equals(this.upperBound);
    }

    public boolean contains(C c) {
        Preconditions.checkNotNull(c);
        return this.lowerBound.isLessThan(c) && !this.upperBound.isLessThan(c);
    }

    @Override
    public boolean apply(C c) {
        return this.contains(c);
    }

    public boolean containsAll(Iterable<? extends C> iterable) {
        if (Iterables.isEmpty(iterable)) {
            return true;
        }
        if (iterable instanceof SortedSet) {
            SortedSet<? extends C> sortedSet = Range.cast(iterable);
            Object object = sortedSet.comparator();
            if (Ordering.natural().equals(object) || object == null) {
                return this.contains((Comparable)sortedSet.first()) && this.contains((Comparable)sortedSet.last());
            }
        }
        for (Object object : iterable) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    public boolean encloses(Range<C> range) {
        return this.lowerBound.compareTo(range.lowerBound) <= 0 && this.upperBound.compareTo(range.upperBound) >= 0;
    }

    public Range<C> intersection(Range<C> range) {
        Cut<C> cut = Ordering.natural().max(this.lowerBound, range.lowerBound);
        Cut<C> cut2 = Ordering.natural().min(this.upperBound, range.upperBound);
        return Ranges.create(cut, cut2);
    }

    public boolean isConnected(Range<C> range) {
        return this.lowerBound.compareTo(range.upperBound) <= 0 && range.lowerBound.compareTo(this.upperBound) <= 0;
    }

    public Range<C> span(Range<C> range) {
        Cut<C> cut = Ordering.natural().min(this.lowerBound, range.lowerBound);
        Cut<C> cut2 = Ordering.natural().max(this.upperBound, range.upperBound);
        return Ranges.create(cut, cut2);
    }

    @GwtCompatible(serializable=false)
    public ContiguousSet<C> asSet(DiscreteDomain<C> discreteDomain) {
        Preconditions.checkNotNull(discreteDomain);
        Range<C> range = this;
        try {
            if (!this.hasLowerBound()) {
                range = range.intersection(Ranges.atLeast(discreteDomain.minValue()));
            }
            if (!this.hasUpperBound()) {
                range = range.intersection(Ranges.atMost(discreteDomain.maxValue()));
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException);
        }
        boolean bl = range.isEmpty() || Range.compareOrThrow(this.lowerBound.leastValueAbove(discreteDomain), this.upperBound.greatestValueBelow(discreteDomain)) > 0;
        return bl ? new EmptyContiguousSet<C>(discreteDomain) : new RegularContiguousSet<C>(range, discreteDomain);
    }

    public Range<C> canonical(DiscreteDomain<C> discreteDomain) {
        Preconditions.checkNotNull(discreteDomain);
        Cut<C> cut = this.lowerBound.canonical(discreteDomain);
        Cut<C> cut2 = this.upperBound.canonical(discreteDomain);
        return cut == this.lowerBound && cut2 == this.upperBound ? this : Ranges.create(cut, cut2);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (object instanceof Range) {
            Range range = (Range)object;
            return this.lowerBound.equals(range.lowerBound) && this.upperBound.equals(range.upperBound);
        }
        return false;
    }

    public int hashCode() {
        return this.lowerBound.hashCode() * 31 + this.upperBound.hashCode();
    }

    public String toString() {
        return Range.toString(this.lowerBound, this.upperBound);
    }

    private static String toString(Cut<?> cut, Cut<?> cut2) {
        StringBuilder stringBuilder = new StringBuilder(16);
        cut.describeAsLowerBound(stringBuilder);
        stringBuilder.append('\u2025');
        cut2.describeAsUpperBound(stringBuilder);
        return stringBuilder.toString();
    }

    private static <T> SortedSet<T> cast(Iterable<T> iterable) {
        return (SortedSet)iterable;
    }

    static int compareOrThrow(Comparable comparable, Comparable comparable2) {
        return comparable.compareTo(comparable2);
    }
}

