/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.Collections2;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient LinkedEntry<K, V>[] entries;
    private final transient LinkedEntry<K, V>[] table;
    private final transient int mask;
    private final transient int keySetHashCode;
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    RegularImmutableMap(Map.Entry<?, ?> ... entryArray) {
        int n = entryArray.length;
        this.entries = this.createEntryArray(n);
        int n2 = RegularImmutableMap.chooseTableSize(n);
        this.table = this.createEntryArray(n2);
        this.mask = n2 - 1;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            LinkedEntry<K, V> linkedEntry;
            Map.Entry<?, ?> entry = entryArray[i];
            Object obj = entry.getKey();
            int n4 = obj.hashCode();
            n3 += n4;
            int n5 = Hashing.smear(n4) & this.mask;
            LinkedEntry<?, ?> linkedEntry2 = RegularImmutableMap.newLinkedEntry(obj, entry.getValue(), linkedEntry);
            this.table[n5] = linkedEntry2;
            this.entries[i] = linkedEntry2;
            for (linkedEntry = this.table[n5]; linkedEntry != null; linkedEntry = linkedEntry.next()) {
                Preconditions.checkArgument(!obj.equals(linkedEntry.getKey()), "duplicate key: %s", obj);
            }
        }
        this.keySetHashCode = n3;
    }

    private static int chooseTableSize(int n) {
        int n2 = Integer.highestOneBit(n) << 1;
        Preconditions.checkArgument(n2 > 0, "table too large: %s", n);
        return n2;
    }

    private LinkedEntry<K, V>[] createEntryArray(int n) {
        return new LinkedEntry[n];
    }

    private static <K, V> LinkedEntry<K, V> newLinkedEntry(K k, V v, @Nullable LinkedEntry<K, V> linkedEntry) {
        return linkedEntry == null ? new TerminalEntry<K, V>(k, v) : new NonTerminalEntry<K, V>(k, v, linkedEntry);
    }

    @Override
    public V get(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        int n = Hashing.smear(object.hashCode()) & this.mask;
        for (LinkedEntry<K, V> linkedEntry = this.table[n]; linkedEntry != null; linkedEntry = linkedEntry.next()) {
            Object k = linkedEntry.getKey();
            if (!object.equals(k)) continue;
            return linkedEntry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        for (LinkedEntry<K, V> linkedEntry : this.entries) {
            if (!linkedEntry.getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> immutableSet = this.entrySet;
        return immutableSet == null ? (this.entrySet = new EntrySet(this)) : immutableSet;
    }

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> immutableSet = this.keySet;
        return immutableSet == null ? (this.keySet = new KeySet(this)) : immutableSet;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> immutableCollection = this.values;
        return immutableCollection == null ? (this.values = new Values(this)) : immutableCollection;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = Collections2.newStringBuilderForCollection(this.size()).append('{');
        Collections2.STANDARD_JOINER.appendTo(stringBuilder, (Object[])this.entries);
        return stringBuilder.append('}').toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values<V>
    extends ImmutableCollection<V> {
        final RegularImmutableMap<?, V> map;

        Values(RegularImmutableMap<?, V> regularImmutableMap) {
            this.map = regularImmutableMap;
        }

        @Override
        public int size() {
            return ((RegularImmutableMap)this.map).entries.length;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return new AbstractIndexedListIterator<V>(((RegularImmutableMap)this.map).entries.length){

                @Override
                protected V get(int n) {
                    return Values.this.map.entries[n].getValue();
                }
            };
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsValue(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeySet<K, V>
    extends ImmutableSet.TransformedImmutableSet<Map.Entry<K, V>, K> {
        final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> regularImmutableMap) {
            super(((RegularImmutableMap)regularImmutableMap).entries, ((RegularImmutableMap)regularImmutableMap).keySetHashCode);
            this.map = regularImmutableMap;
        }

        @Override
        K transform(Map.Entry<K, V> entry) {
            return entry.getKey();
        }

        @Override
        public boolean contains(Object object) {
            return this.map.containsKey(object);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EntrySet<K, V>
    extends ImmutableSet.ArrayImmutableSet<Map.Entry<K, V>> {
        final transient RegularImmutableMap<K, V> map;

        EntrySet(RegularImmutableMap<K, V> regularImmutableMap) {
            super(((RegularImmutableMap)regularImmutableMap).entries);
            this.map = regularImmutableMap;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                V v = this.map.get(entry.getKey());
                return v != null && v.equals(entry.getValue());
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static final class TerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        TerminalEntry(K k, V v) {
            super(k, v);
        }

        @Override
        @Nullable
        public LinkedEntry<K, V> next() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    private static final class NonTerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        final LinkedEntry<K, V> next;

        NonTerminalEntry(K k, V v, LinkedEntry<K, V> linkedEntry) {
            super(k, v);
            this.next = linkedEntry;
        }

        @Override
        public LinkedEntry<K, V> next() {
            return this.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LinkedEntry<K, V>
    extends Map.Entry<K, V> {
        @Nullable
        public LinkedEntry<K, V> next();
    }
}

