/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedLists;
import com.google.common.collect.TransformedImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RegularImmutableSortedMultiset<E>
extends ImmutableSortedMultiset<E> {
    final transient ImmutableList<CumulativeCountEntry<E>> entries;

    static <E> RegularImmutableSortedMultiset<E> createFromSorted(Comparator<? super E> comparator, List<? extends Multiset.Entry<E>> list) {
        ArrayList<CumulativeCountEntry<E>> arrayList = Lists.newArrayListWithCapacity(list.size());
        CumulativeCountEntry<E> cumulativeCountEntry = null;
        for (Multiset.Entry<E> entry : list) {
            cumulativeCountEntry = new CumulativeCountEntry<E>(entry.getElement(), entry.getCount(), cumulativeCountEntry);
            arrayList.add(cumulativeCountEntry);
        }
        return new RegularImmutableSortedMultiset<E>(comparator, ImmutableList.copyOf(arrayList));
    }

    RegularImmutableSortedMultiset(Comparator<? super E> comparator, ImmutableList<CumulativeCountEntry<E>> immutableList) {
        super(comparator);
        this.entries = immutableList;
        assert (!immutableList.isEmpty());
    }

    ImmutableList<E> elementList() {
        return new TransformedImmutableList<CumulativeCountEntry<E>, E>(this.entries){

            @Override
            E transform(CumulativeCountEntry<E> cumulativeCountEntry) {
                return cumulativeCountEntry.getElement();
            }
        };
    }

    @Override
    ImmutableSortedSet<E> createElementSet() {
        return new RegularImmutableSortedSet<E>(this.elementList(), this.comparator());
    }

    @Override
    ImmutableSortedSet<E> createDescendingElementSet() {
        return new RegularImmutableSortedSet<E>(this.elementList().reverse(), this.reverseComparator());
    }

    @Override
    UnmodifiableIterator<Multiset.Entry<E>> entryIterator() {
        return this.entries.iterator();
    }

    @Override
    UnmodifiableIterator<Multiset.Entry<E>> descendingEntryIterator() {
        return this.entries.reverse().iterator();
    }

    @Override
    public CumulativeCountEntry<E> firstEntry() {
        return (CumulativeCountEntry)this.entries.get(0);
    }

    @Override
    public CumulativeCountEntry<E> lastEntry() {
        return (CumulativeCountEntry)this.entries.get(this.entries.size() - 1);
    }

    @Override
    public int size() {
        Multiset.Entry entry = this.firstEntry();
        Multiset.Entry entry2 = this.lastEntry();
        return Ints.saturatedCast(((CumulativeCountEntry)entry2).cumulativeCount - ((CumulativeCountEntry)entry).cumulativeCount + (long)((CumulativeCountEntry)entry).count);
    }

    @Override
    int distinctElements() {
        return this.entries.size();
    }

    @Override
    boolean isPartialView() {
        return this.entries.isPartialView();
    }

    @Override
    public int count(@Nullable Object object) {
        if (object == null) {
            return 0;
        }
        try {
            int n = SortedLists.binarySearch(this.elementList(), object, this.comparator(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.INVERTED_INSERTION_INDEX);
            return n >= 0 ? ((CumulativeCountEntry)this.entries.get(n)).getCount() : 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public ImmutableSortedMultiset<E> headMultiset(E e, BoundType boundType) {
        int n;
        switch (boundType) {
            case OPEN: {
                n = SortedLists.binarySearch(this.elementList(), Preconditions.checkNotNull(e), this.comparator(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
                break;
            }
            case CLOSED: {
                n = SortedLists.binarySearch(this.elementList(), Preconditions.checkNotNull(e), this.comparator(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER) + 1;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.createSubMultiset(0, n);
    }

    @Override
    public ImmutableSortedMultiset<E> tailMultiset(E e, BoundType boundType) {
        int n;
        switch (boundType) {
            case OPEN: {
                n = SortedLists.binarySearch(this.elementList(), Preconditions.checkNotNull(e), this.comparator(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER) + 1;
                break;
            }
            case CLOSED: {
                n = SortedLists.binarySearch(this.elementList(), Preconditions.checkNotNull(e), this.comparator(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.createSubMultiset(n, this.distinctElements());
    }

    private ImmutableSortedMultiset<E> createSubMultiset(int n, int n2) {
        if (n == 0 && n2 == this.entries.size()) {
            return this;
        }
        if (n >= n2) {
            return RegularImmutableSortedMultiset.emptyMultiset(this.comparator());
        }
        return new RegularImmutableSortedMultiset(this.comparator(), this.entries.subList(n, n2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CumulativeCountEntry<E>
    extends Multisets.AbstractEntry<E> {
        final E element;
        final int count;
        final long cumulativeCount;

        CumulativeCountEntry(E e, int n, @Nullable CumulativeCountEntry<E> cumulativeCountEntry) {
            this.element = e;
            this.count = n;
            this.cumulativeCount = (long)n + (cumulativeCountEntry == null ? 0L : cumulativeCountEntry.cumulativeCount);
        }

        @Override
        public E getElement() {
            return this.element;
        }

        @Override
        public int getCount() {
            return this.count;
        }
    }
}

