/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedMapDifference;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
@Beta
@GwtCompatible
public final class SortedMaps {
    private SortedMaps() {
    }

    @Deprecated
    public static <K, V1, V2> SortedMap<K, V2> transformValues(SortedMap<K, V1> sortedMap, Function<? super V1, V2> function) {
        return Maps.transformValues(sortedMap, function);
    }

    @Deprecated
    public static <K, V1, V2> SortedMap<K, V2> transformEntries(SortedMap<K, V1> sortedMap, Maps.EntryTransformer<? super K, ? super V1, V2> entryTransformer) {
        return Maps.transformEntries(sortedMap, entryTransformer);
    }

    @Deprecated
    public static <K, V> SortedMapDifference<K, V> difference(SortedMap<K, ? extends V> sortedMap, Map<? extends K, ? extends V> map) {
        return Maps.difference(sortedMap, map);
    }

    static <E> Comparator<? super E> orNaturalOrder(@Nullable Comparator<? super E> comparator) {
        if (comparator != null) {
            return comparator;
        }
        return Ordering.natural();
    }

    @GwtIncompatible(value="untested")
    public static <K, V> SortedMap<K, V> filterKeys(SortedMap<K, V> sortedMap, final Predicate<? super K> predicate) {
        Preconditions.checkNotNull(predicate);
        Predicate predicate2 = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> entry) {
                return predicate.apply(entry.getKey());
            }
        };
        return SortedMaps.filterEntries(sortedMap, predicate2);
    }

    @GwtIncompatible(value="untested")
    public static <K, V> SortedMap<K, V> filterValues(SortedMap<K, V> sortedMap, final Predicate<? super V> predicate) {
        Preconditions.checkNotNull(predicate);
        Predicate predicate2 = new Predicate<Map.Entry<K, V>>(){

            @Override
            public boolean apply(Map.Entry<K, V> entry) {
                return predicate.apply(entry.getValue());
            }
        };
        return SortedMaps.filterEntries(sortedMap, predicate2);
    }

    @GwtIncompatible(value="untested")
    public static <K, V> SortedMap<K, V> filterEntries(SortedMap<K, V> sortedMap, Predicate<? super Map.Entry<K, V>> predicate) {
        Preconditions.checkNotNull(predicate);
        return sortedMap instanceof FilteredSortedMap ? SortedMaps.filterFiltered((FilteredSortedMap)sortedMap, predicate) : new FilteredSortedMap<K, V>(Preconditions.checkNotNull(sortedMap), predicate);
    }

    private static <K, V> SortedMap<K, V> filterFiltered(FilteredSortedMap<K, V> filteredSortedMap, Predicate<? super Map.Entry<K, V>> predicate) {
        Predicate<? super Map.Entry<K, V>> predicate2 = Predicates.and(filteredSortedMap.predicate, predicate);
        return new FilteredSortedMap<K, V>(filteredSortedMap.sortedMap(), predicate2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteredSortedMap<K, V>
    extends Maps.FilteredEntryMap<K, V>
    implements SortedMap<K, V> {
        FilteredSortedMap(SortedMap<K, V> sortedMap, Predicate<? super Map.Entry<K, V>> predicate) {
            super(sortedMap, predicate);
        }

        SortedMap<K, V> sortedMap() {
            return (SortedMap)this.unfiltered;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        public K firstKey() {
            return this.keySet().iterator().next();
        }

        @Override
        public K lastKey() {
            SortedMap<K, V> sortedMap = this.sortedMap();
            K k;
            while (!this.apply(k = sortedMap.lastKey(), this.unfiltered.get(k))) {
                sortedMap = this.sortedMap().headMap(k);
            }
            return k;
        }

        @Override
        public SortedMap<K, V> headMap(K k) {
            return new FilteredSortedMap<K, V>(this.sortedMap().headMap(k), this.predicate);
        }

        @Override
        public SortedMap<K, V> subMap(K k, K k2) {
            return new FilteredSortedMap<K, V>(this.sortedMap().subMap(k, k2), this.predicate);
        }

        @Override
        public SortedMap<K, V> tailMap(K k) {
            return new FilteredSortedMap<K, V>(this.sortedMap().tailMap(k), this.predicate);
        }
    }
}

