/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AnnotatedHandlerFinder;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.EventHandler;
import com.google.common.eventbus.HandlerFindingStrategy;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public class EventBus {
    private final SetMultimap<Class<?>, EventHandler> handlersByType = Multimaps.newSetMultimap(new ConcurrentHashMap(), new Supplier<Set<EventHandler>>(){

        @Override
        public Set<EventHandler> get() {
            return new CopyOnWriteArraySet<EventHandler>();
        }
    });
    private final Logger logger;
    private final HandlerFindingStrategy finder = new AnnotatedHandlerFinder();
    private final ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>> eventsToDispatch = new ThreadLocal<ConcurrentLinkedQueue<EventWithHandler>>(){

        @Override
        protected ConcurrentLinkedQueue<EventWithHandler> initialValue() {
            return new ConcurrentLinkedQueue<EventWithHandler>();
        }
    };
    private final ThreadLocal<Boolean> isDispatching = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private LoadingCache<Class<?>, Set<Class<?>>> flattenHierarchyCache = CacheBuilder.newBuilder().weakKeys().build(new CacheLoader<Class<?>, Set<Class<?>>>(){

        @Override
        public Set<Class<?>> load(Class<?> clazz) throws Exception {
            LinkedList<Class<?>> linkedList = Lists.newLinkedList();
            HashSet<Class<?>> hashSet = Sets.newHashSet();
            linkedList.add(clazz);
            while (!linkedList.isEmpty()) {
                Class clazz2 = (Class)linkedList.remove(0);
                hashSet.add(clazz2);
                Class clazz3 = clazz2.getSuperclass();
                if (clazz3 != null) {
                    linkedList.add(clazz3);
                }
                for (Class<?> clazz4 : clazz2.getInterfaces()) {
                    linkedList.add(clazz4);
                }
            }
            return hashSet;
        }
    });

    public EventBus() {
        this("default");
    }

    public EventBus(String string) {
        this.logger = Logger.getLogger(EventBus.class.getName() + "." + string);
    }

    public void register(Object object) {
        this.handlersByType.putAll(this.finder.findAllHandlers(object));
    }

    public void unregister(Object object) {
        Multimap<Class<?>, EventHandler> multimap = this.finder.findAllHandlers(object);
        for (Map.Entry<Class<?>, Collection<EventHandler>> entry : multimap.asMap().entrySet()) {
            Set<EventHandler> set = this.getHandlersForEventType(entry.getKey());
            Collection<EventHandler> collection = entry.getValue();
            if (set == null || !set.containsAll(entry.getValue())) {
                throw new IllegalArgumentException("missing event handler for an annotated method. Is " + object + " registered?");
            }
            set.removeAll(collection);
        }
    }

    public void post(Object object) {
        Set<Class<?>> set = this.flattenHierarchy(object.getClass());
        boolean bl = false;
        for (Class<?> clazz : set) {
            Set<EventHandler> set2 = this.getHandlersForEventType(clazz);
            if (set2 == null || set2.isEmpty()) continue;
            bl = true;
            for (EventHandler eventHandler : set2) {
                this.enqueueEvent(object, eventHandler);
            }
        }
        if (!bl && !(object instanceof DeadEvent)) {
            this.post(new DeadEvent(this, object));
        }
        this.dispatchQueuedEvents();
    }

    protected void enqueueEvent(Object object, EventHandler eventHandler) {
        this.eventsToDispatch.get().offer(new EventWithHandler(object, eventHandler));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchQueuedEvents() {
        if (this.isDispatching.get().booleanValue()) {
            return;
        }
        this.isDispatching.set(true);
        try {
            EventWithHandler eventWithHandler;
            while ((eventWithHandler = this.eventsToDispatch.get().poll()) != null) {
                this.dispatch(eventWithHandler.event, eventWithHandler.handler);
            }
        }
        finally {
            this.isDispatching.set(false);
        }
    }

    protected void dispatch(Object object, EventHandler eventHandler) {
        try {
            eventHandler.handleEvent(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.logger.log(Level.SEVERE, "Could not dispatch event: " + object + " to handler " + eventHandler, invocationTargetException);
        }
    }

    Set<EventHandler> getHandlersForEventType(Class<?> clazz) {
        return this.handlersByType.get(clazz);
    }

    protected Set<EventHandler> newHandlerSet() {
        return new CopyOnWriteArraySet<EventHandler>();
    }

    @VisibleForTesting
    Set<Class<?>> flattenHierarchy(Class<?> clazz) {
        try {
            return this.flattenHierarchyCache.get(clazz);
        }
        catch (ExecutionException executionException) {
            throw Throwables.propagate(executionException.getCause());
        }
    }

    static class EventWithHandler {
        final Object event;
        final EventHandler handler;

        public EventWithHandler(Object object, EventHandler eventHandler) {
            this.event = object;
            this.handler = eventHandler;
        }
    }
}

