/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.security.MessageDigest;

@Beta
public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int asInt();

    public abstract long asLong();

    public abstract byte[] asBytes();

    public int writeBytesTo(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.asBytes();
        n2 = Ints.min(n2, byArray2.length);
        Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
        System.arraycopy(byArray2, 0, byArray, n, n2);
        return n2;
    }

    public abstract int bits();

    public boolean equals(Object object) {
        if (object instanceof HashCode) {
            HashCode hashCode = (HashCode)object;
            return MessageDigest.isEqual(this.asBytes(), hashCode.asBytes());
        }
        return false;
    }

    public int hashCode() {
        return this.asInt();
    }

    public String toString() {
        byte[] byArray = this.asBytes();
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(hexDigits[by >> 4 & 0xF]).append(hexDigits[by & 0xF]);
        }
        return stringBuilder.toString();
    }
}

