/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractCompositeHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.MessageDigestHashFunction;
import com.google.common.hash.Murmur3_128HashFunction;
import com.google.common.hash.Murmur3_32HashFunction;
import com.google.common.primitives.UnsignedInts;
import java.nio.ByteBuffer;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Hashing {
    private static final Murmur3_32HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0);
    private static final Murmur3_128HashFunction MURMUR3_128 = new Murmur3_128HashFunction(0);
    private static final HashFunction MD5 = new MessageDigestHashFunction("MD5");
    private static final HashFunction SHA_1 = new MessageDigestHashFunction("SHA-1");
    private static final HashFunction SHA_256 = new MessageDigestHashFunction("SHA-256");
    private static final HashFunction SHA_512 = new MessageDigestHashFunction("SHA-512");

    private Hashing() {
    }

    public static HashFunction goodFastHash(int n) {
        int n2 = Hashing.checkPositiveAndMakeMultipleOf32(n);
        if (n2 == 32) {
            return Hashing.murmur3_32();
        }
        if (n2 <= 128) {
            return Hashing.murmur3_128();
        }
        int n3 = (n2 + 127) / 128;
        HashFunction[] hashFunctionArray = new HashFunction[n3];
        for (int i = 0; i < n3; ++i) {
            hashFunctionArray[i] = Hashing.murmur3_128(i * 1500450271);
        }
        return new ConcatenatedHashFunction(hashFunctionArray);
    }

    public static HashFunction murmur3_32(int n) {
        return new Murmur3_32HashFunction(n);
    }

    public static HashFunction murmur3_32() {
        return MURMUR3_32;
    }

    public static HashFunction murmur3_128(int n) {
        return new Murmur3_128HashFunction(n);
    }

    public static HashFunction murmur3_128() {
        return MURMUR3_128;
    }

    public static HashFunction md5() {
        return MD5;
    }

    public static HashFunction sha1() {
        return SHA_1;
    }

    public static HashFunction sha256() {
        return SHA_256;
    }

    public static HashFunction sha512() {
        return SHA_512;
    }

    public static long padToLong(HashCode hashCode) {
        return hashCode.bits() < 64 ? UnsignedInts.toLong(hashCode.asInt()) : hashCode.asLong();
    }

    public static int consistentHash(HashCode hashCode, int n) {
        return Hashing.consistentHash(Hashing.padToLong(hashCode), n);
    }

    public static int consistentHash(long l, int n) {
        double d;
        int n2;
        Preconditions.checkArgument(n > 0, "buckets must be positive: %s", n);
        long l2 = l;
        int n3 = 0;
        while ((n2 = (int)((double)(n3 + 1) * (d = 2.147483648E9 / (double)((int)((l2 = 2862933555777941757L * l2 + 1L) >>> 33) + 1)))) >= 0 && n2 < n) {
            n3 = n2;
        }
        return n3;
    }

    public static HashCode combineOrdered(Iterable<HashCode> iterable) {
        Iterator<HashCode> iterator = iterable.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "Must be at least 1 hash code to combine.");
        int n = iterator.next().bits();
        byte[] byArray = new byte[n / 8];
        for (HashCode hashCode : iterable) {
            byte[] byArray2 = hashCode.asBytes();
            Preconditions.checkArgument(byArray2.length == byArray.length, "All hashcodes must have the same bit length.");
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[i] = (byte)(byArray[i] * 37 ^ byArray2[i]);
            }
        }
        return HashCodes.fromBytes(byArray);
    }

    public static HashCode combineUnordered(Iterable<HashCode> iterable) {
        Iterator<HashCode> iterator = iterable.iterator();
        Preconditions.checkArgument(iterator.hasNext(), "Must be at least 1 hash code to combine.");
        byte[] byArray = new byte[iterator.next().bits() / 8];
        for (HashCode hashCode : iterable) {
            byte[] byArray2 = hashCode.asBytes();
            Preconditions.checkArgument(byArray2.length == byArray.length, "All hashcodes must have the same bit length.");
            for (int i = 0; i < byArray2.length; ++i) {
                int n = i;
                byArray[n] = (byte)(byArray[n] + byArray2[i]);
            }
        }
        return HashCodes.fromBytes(byArray);
    }

    static int checkPositiveAndMakeMultipleOf32(int n) {
        Preconditions.checkArgument(n > 0, "Number of bits must be positive");
        return n + 31 & 0xFFFFFFE0;
    }

    private static class ConcatenatedHashFunction
    extends AbstractCompositeHashFunction {
        final int bits;

        ConcatenatedHashFunction(HashFunction[] hashFunctionArray) {
            super(hashFunctionArray);
            int n = 0;
            for (HashFunction hashFunction : this.functions) {
                n += hashFunction.bits();
            }
            this.bits = n;
        }

        HashCode makeHash(Hasher[] hasherArray) {
            byte[] byArray = new byte[this.bits / 8];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            for (Hasher hasher : hasherArray) {
                byteBuffer.put(hasher.hash().asBytes());
            }
            return HashCodes.fromBytes(byArray);
        }

        public int bits() {
            return this.bits;
        }
    }
}

