/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.Hasher;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

final class MessageDigestHashFunction
extends AbstractStreamingHashFunction {
    private final String algorithmName;
    private final int bits;

    MessageDigestHashFunction(String string) {
        this.algorithmName = string;
        this.bits = MessageDigestHashFunction.getMessageDigest(string).getDigestLength() * 8;
    }

    public int bits() {
        return this.bits;
    }

    private static MessageDigest getMessageDigest(String string) {
        try {
            return MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public Hasher newHasher() {
        return new MessageDigestHasher(MessageDigestHashFunction.getMessageDigest(this.algorithmName));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageDigestHasher
    implements Hasher {
        private final MessageDigest digest;
        private final ByteBuffer scratch;
        private boolean done;

        private MessageDigestHasher(MessageDigest messageDigest) {
            this.digest = messageDigest;
            this.scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public Hasher putByte(byte by) {
            this.checkNotDone();
            this.digest.update(by);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] byArray) {
            this.checkNotDone();
            this.digest.update(byArray);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] byArray, int n, int n2) {
            this.checkNotDone();
            Preconditions.checkPositionIndexes(n, n + n2, byArray.length);
            this.digest.update(byArray, n, n2);
            return this;
        }

        @Override
        public Hasher putShort(short s) {
            this.checkNotDone();
            this.scratch.putShort(s);
            this.digest.update(this.scratch.array(), 0, 2);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putInt(int n) {
            this.checkNotDone();
            this.scratch.putInt(n);
            this.digest.update(this.scratch.array(), 0, 4);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putLong(long l) {
            this.checkNotDone();
            this.scratch.putLong(l);
            this.digest.update(this.scratch.array(), 0, 8);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putFloat(float f) {
            this.checkNotDone();
            this.scratch.putFloat(f);
            this.digest.update(this.scratch.array(), 0, 4);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putDouble(double d) {
            this.checkNotDone();
            this.scratch.putDouble(d);
            this.digest.update(this.scratch.array(), 0, 8);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putBoolean(boolean bl) {
            return this.putByte(bl ? (byte)1 : 0);
        }

        @Override
        public Hasher putChar(char c) {
            this.checkNotDone();
            this.scratch.putChar(c);
            this.digest.update(this.scratch.array(), 0, 2);
            this.scratch.clear();
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                this.putChar(charSequence.charAt(i));
            }
            return this;
        }

        @Override
        public Hasher putString(CharSequence charSequence, Charset charset) {
            try {
                return this.putBytes(((Object)charSequence).toString().getBytes(charset.name()));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
        }

        @Override
        public <T> Hasher putObject(T t, Funnel<? super T> funnel) {
            this.checkNotDone();
            funnel.funnel(t, this);
            return this;
        }

        private void checkNotDone() {
            Preconditions.checkState(!this.done, "Cannot use Hasher after calling #hash() on it");
        }

        @Override
        public HashCode hash() {
            this.done = true;
            return HashCodes.fromBytes(this.digest.digest());
        }
    }
}

