/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.Hasher;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class Murmur3_128HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_128HashFunction(int n) {
        this.seed = n;
    }

    public int bits() {
        return 128;
    }

    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    private static final class Murmur3_128Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        long h1;
        long h2;
        long c1 = -8663945395140668459L;
        long c2 = 5545529020109919103L;
        int len;

        Murmur3_128Hasher(int n) {
            super(16);
            this.h1 = n;
            this.h2 = n;
        }

        protected void process(ByteBuffer byteBuffer) {
            long l = byteBuffer.getLong();
            long l2 = byteBuffer.getLong();
            this.len += 16;
            this.bmix64(l, l2);
        }

        private void bmix64(long l, long l2) {
            l *= this.c1;
            l = Long.rotateLeft(l, 31);
            this.h1 ^= (l *= this.c2);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            l2 *= this.c2;
            l2 = Long.rotateLeft(l2, 33);
            this.h2 ^= (l2 *= this.c1);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        protected void processRemaining(ByteBuffer byteBuffer) {
            long l = 0L;
            long l2 = 0L;
            this.len += byteBuffer.remaining();
            switch (byteBuffer.remaining()) {
                case 15: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(14)) << 48;
                }
                case 14: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(13)) << 40;
                }
                case 13: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(12)) << 32;
                }
                case 12: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(11)) << 24;
                }
                case 11: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(10)) << 16;
                }
                case 10: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(9)) << 8;
                }
                case 9: {
                    l2 ^= (long)UnsignedBytes.toInt(byteBuffer.get(8)) << 0;
                    l2 *= this.c2;
                    l2 = Long.rotateLeft(l2, 33);
                    this.h2 ^= (l2 *= this.c1);
                }
                case 8: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(7)) << 56;
                }
                case 7: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(6)) << 48;
                }
                case 6: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(5)) << 40;
                }
                case 5: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(4)) << 32;
                }
                case 4: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(3)) << 24;
                }
                case 3: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(2)) << 16;
                }
                case 2: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(1)) << 8;
                }
                case 1: {
                    l ^= (long)UnsignedBytes.toInt(byteBuffer.get(0)) << 0;
                    l *= this.c1;
                    l = Long.rotateLeft(l, 31);
                    this.h1 ^= (l *= this.c2);
                }
            }
        }

        public HashCode makeHash() {
            this.h1 ^= (long)this.len;
            this.h2 ^= (long)this.len;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = this.fmix64(this.h1);
            this.h2 = this.fmix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putLong(this.h1);
            byteBuffer.putLong(this.h2);
            return HashCodes.fromBytes(byteBuffer.array());
        }

        private long fmix64(long l) {
            l ^= l >>> 33;
            l *= -49064778989728563L;
            l ^= l >>> 33;
            l *= -4265267296055464877L;
            l ^= l >>> 33;
            return l;
        }
    }
}

