/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.io.AppendableWriter;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.LineProcessor;
import com.google.common.io.LineReader;
import com.google.common.io.MultiReader;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class CharStreams {
    private static final int BUF_SIZE = 2048;

    private CharStreams() {
    }

    public static InputSupplier<StringReader> newReaderSupplier(final String string) {
        Preconditions.checkNotNull(string);
        return new InputSupplier<StringReader>(){

            @Override
            public StringReader getInput() {
                return new StringReader(string);
            }
        };
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(final InputSupplier<? extends InputStream> inputSupplier, final Charset charset) {
        Preconditions.checkNotNull(inputSupplier);
        Preconditions.checkNotNull(charset);
        return new InputSupplier<InputStreamReader>(){

            @Override
            public InputStreamReader getInput() throws IOException {
                return new InputStreamReader((InputStream)inputSupplier.getInput(), charset);
            }
        };
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(final OutputSupplier<? extends OutputStream> outputSupplier, final Charset charset) {
        Preconditions.checkNotNull(outputSupplier);
        Preconditions.checkNotNull(charset);
        return new OutputSupplier<OutputStreamWriter>(){

            @Override
            public OutputStreamWriter getOutput() throws IOException {
                return new OutputStreamWriter((OutputStream)outputSupplier.getOutput(), charset);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <W extends Appendable & Closeable> void write(CharSequence charSequence, OutputSupplier<W> outputSupplier) throws IOException {
        Preconditions.checkNotNull(charSequence);
        boolean bl = true;
        Appendable appendable = (Appendable)outputSupplier.getOutput();
        try {
            appendable.append(charSequence);
            bl = false;
        }
        finally {
            Closeables.close((Closeable)((Object)appendable), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static <R extends Readable & Closeable, W extends Appendable & Closeable> long copy(InputSupplier<R> inputSupplier, OutputSupplier<W> outputSupplier) throws IOException {
        int n = 0;
        Readable readable = (Readable)inputSupplier.getInput();
        Appendable appendable = (Appendable)outputSupplier.getOutput();
        long l = CharStreams.copy(readable, appendable);
        long l2 = l;
        Closeables.close((Closeable)((Object)appendable), ++n < 1);
        Closeables.close((Closeable)((Object)readable), ++n < 2);
        return l2;
        {
            catch (Throwable throwable) {
                try {
                    Closeables.close((Closeable)((Object)appendable), n < 1);
                    ++n;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Closeables.close((Closeable)((Object)readable), n < 2);
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> long copy(InputSupplier<R> inputSupplier, Appendable appendable) throws IOException {
        boolean bl = true;
        Readable readable = (Readable)inputSupplier.getInput();
        try {
            long l = CharStreams.copy(readable, appendable);
            bl = false;
            long l2 = l;
            return l2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl);
        }
    }

    public static long copy(Readable readable, Appendable appendable) throws IOException {
        int n;
        CharBuffer charBuffer = CharBuffer.allocate(2048);
        long l = 0L;
        while ((n = readable.read(charBuffer)) != -1) {
            charBuffer.flip();
            appendable.append(charBuffer, 0, n);
            l += (long)n;
        }
        return l;
    }

    public static String toString(Readable readable) throws IOException {
        return CharStreams.toStringBuilder(readable).toString();
    }

    public static <R extends Readable & Closeable> String toString(InputSupplier<R> inputSupplier) throws IOException {
        return CharStreams.toStringBuilder(inputSupplier).toString();
    }

    private static StringBuilder toStringBuilder(Readable readable) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        CharStreams.copy(readable, (Appendable)stringBuilder);
        return stringBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <R extends Readable & Closeable> StringBuilder toStringBuilder(InputSupplier<R> inputSupplier) throws IOException {
        boolean bl = true;
        Readable readable = (Readable)inputSupplier.getInput();
        try {
            StringBuilder stringBuilder = CharStreams.toStringBuilder(readable);
            bl = false;
            StringBuilder stringBuilder2 = stringBuilder;
            return stringBuilder2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> String readFirstLine(InputSupplier<R> inputSupplier) throws IOException {
        boolean bl = true;
        Readable readable = (Readable)inputSupplier.getInput();
        try {
            String string = new LineReader(readable).readLine();
            bl = false;
            String string2 = string;
            return string2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> List<String> readLines(InputSupplier<R> inputSupplier) throws IOException {
        boolean bl = true;
        Readable readable = (Readable)inputSupplier.getInput();
        try {
            List<String> list = CharStreams.readLines(readable);
            bl = false;
            List<String> list2 = list;
            return list2;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl);
        }
    }

    public static List<String> readLines(Readable readable) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineReader lineReader = new LineReader(readable);
        while ((string = lineReader.readLine()) != null) {
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable, T> T readLines(InputSupplier<R> inputSupplier, LineProcessor<T> lineProcessor) throws IOException {
        boolean bl = true;
        Readable readable = (Readable)inputSupplier.getInput();
        try {
            String string;
            LineReader lineReader = new LineReader(readable);
            while ((string = lineReader.readLine()) != null && lineProcessor.processLine(string)) {
            }
            bl = false;
        }
        finally {
            Closeables.close((Closeable)((Object)readable), bl);
        }
        return lineProcessor.getResult();
    }

    public static InputSupplier<Reader> join(final Iterable<? extends InputSupplier<? extends Reader>> iterable) {
        return new InputSupplier<Reader>(){

            @Override
            public Reader getInput() throws IOException {
                return new MultiReader(iterable.iterator());
            }
        };
    }

    public static InputSupplier<Reader> join(InputSupplier<? extends Reader> ... inputSupplierArray) {
        return CharStreams.join(Arrays.asList(inputSupplierArray));
    }

    public static void skipFully(Reader reader, long l) throws IOException {
        while (l > 0L) {
            long l2 = reader.skip(l);
            if (l2 == 0L) {
                if (reader.read() == -1) {
                    throw new EOFException();
                }
                --l;
                continue;
            }
            l -= l2;
        }
    }

    public static Writer asWriter(Appendable appendable) {
        if (appendable instanceof Writer) {
            return (Writer)appendable;
        }
        return new AppendableWriter(appendable);
    }
}

