/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedLongs;
import java.io.Serializable;
import java.math.BigInteger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible(serializable=true)
public class UnsignedLong
extends Number
implements Comparable<UnsignedLong>,
Serializable {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    public static final UnsignedLong ZERO = new UnsignedLong(0L);
    public static final UnsignedLong ONE = new UnsignedLong(1L);
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    private final long value;

    protected UnsignedLong(long l) {
        this.value = l;
    }

    public static UnsignedLong asUnsigned(long l) {
        return new UnsignedLong(l);
    }

    public static UnsignedLong valueOf(BigInteger bigInteger) {
        Preconditions.checkNotNull(bigInteger);
        Preconditions.checkArgument(bigInteger.signum() >= 0 && bigInteger.bitLength() <= 64, "value (%s) is outside the range for an unsigned long value", bigInteger);
        return UnsignedLong.asUnsigned(bigInteger.longValue());
    }

    public static UnsignedLong valueOf(String string) {
        return UnsignedLong.valueOf(string, 10);
    }

    public static UnsignedLong valueOf(String string, int n) {
        return UnsignedLong.asUnsigned(UnsignedLongs.parseUnsignedLong(string, n));
    }

    public UnsignedLong add(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLong.asUnsigned(this.value + unsignedLong.value);
    }

    public UnsignedLong subtract(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLong.asUnsigned(this.value - unsignedLong.value);
    }

    public UnsignedLong multiply(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLong.asUnsigned(this.value * unsignedLong.value);
    }

    public UnsignedLong divide(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLong.asUnsigned(UnsignedLongs.divide(this.value, unsignedLong.value));
    }

    public UnsignedLong remainder(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLong.asUnsigned(UnsignedLongs.remainder(this.value, unsignedLong.value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        float f = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            f += 9.223372E18f;
        }
        return f;
    }

    @Override
    public double doubleValue() {
        double d = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            d += 9.223372036854776E18;
        }
        return d;
    }

    public BigInteger bigIntegerValue() {
        BigInteger bigInteger = BigInteger.valueOf(this.value & Long.MAX_VALUE);
        if (this.value < 0L) {
            bigInteger = bigInteger.setBit(63);
        }
        return bigInteger;
    }

    @Override
    public int compareTo(UnsignedLong unsignedLong) {
        Preconditions.checkNotNull(unsignedLong);
        return UnsignedLongs.compare(this.value, unsignedLong.value);
    }

    public int hashCode() {
        return Longs.hashCode(this.value);
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof UnsignedLong) {
            UnsignedLong unsignedLong = (UnsignedLong)object;
            return this.value == unsignedLong.value;
        }
        return false;
    }

    public String toString() {
        return UnsignedLongs.toString(this.value);
    }

    public String toString(int n) {
        return UnsignedLongs.toString(this.value, n);
    }
}

