/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AbstractCheckedFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Futures {
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_FIRST = Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){

        @Override
        public Boolean apply(Constructor<?> constructor) {
            return Arrays.asList(constructor.getParameterTypes()).contains(String.class);
        }
    }).reverse();

    private Futures() {
    }

    public static <V, X extends Exception> CheckedFuture<V, X> makeChecked(ListenableFuture<V> listenableFuture, Function<Exception, X> function) {
        return new MappingCheckedFuture<V, X>(Preconditions.checkNotNull(listenableFuture), function);
    }

    public static <V> ListenableFuture<V> immediateFuture(@Nullable V v) {
        SettableFuture<V> settableFuture = SettableFuture.create();
        settableFuture.set(v);
        return settableFuture;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateCheckedFuture(@Nullable V v) {
        SettableFuture<V> settableFuture = SettableFuture.create();
        settableFuture.set(v);
        return Futures.makeChecked(settableFuture, new Function<Exception, X>(){

            @Override
            public X apply(Exception exception) {
                throw new AssertionError((Object)"impossible");
            }
        });
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        SettableFuture settableFuture = SettableFuture.create();
        settableFuture.setException(throwable);
        return settableFuture;
    }

    public static <V, X extends Exception> CheckedFuture<V, X> immediateFailedCheckedFuture(final X x) {
        Preconditions.checkNotNull(x);
        return Futures.makeChecked(Futures.immediateFailedFuture(x), new Function<Exception, X>(){

            @Override
            public X apply(Exception exception) {
                return x;
            }
        });
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> listenableFuture, Function<? super I, ? extends ListenableFuture<? extends O>> function) {
        return Futures.chain(listenableFuture, function, MoreExecutors.sameThreadExecutor());
    }

    @Deprecated
    public static <I, O> ListenableFuture<O> chain(ListenableFuture<I> listenableFuture, final Function<? super I, ? extends ListenableFuture<? extends O>> function, Executor executor) {
        Preconditions.checkNotNull(function);
        ChainingListenableFuture chainingListenableFuture = new ChainingListenableFuture(new AsyncFunction<I, O>(){

            @Override
            public ListenableFuture<O> apply(I i) {
                return (ListenableFuture)function.apply(i);
            }
        }, listenableFuture);
        listenableFuture.addListener(chainingListenableFuture, executor);
        return chainingListenableFuture;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction) {
        return Futures.transform(listenableFuture, asyncFunction, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        ChainingListenableFuture chainingListenableFuture = new ChainingListenableFuture(asyncFunction, listenableFuture);
        listenableFuture.addListener(chainingListenableFuture, executor);
        return chainingListenableFuture;
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function) {
        return Futures.transform(listenableFuture, function, (Executor)MoreExecutors.sameThreadExecutor());
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, final Function<? super I, ? extends O> function, Executor executor) {
        Preconditions.checkNotNull(function);
        Function function2 = new Function<I, ListenableFuture<O>>(){

            @Override
            public ListenableFuture<O> apply(I i) {
                Object t = function.apply(i);
                return Futures.immediateFuture(t);
            }
        };
        return Futures.chain(listenableFuture, function2, executor);
    }

    @Beta
    public static <I, O> Future<O> lazyTransform(final Future<I> future, final Function<? super I, ? extends O> function) {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(function);
        return new Future<O>(){

            @Override
            public boolean cancel(boolean bl) {
                return future.cancel(bl);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                return this.applyTransformation(future.get());
            }

            @Override
            public O get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.applyTransformation(future.get(l, timeUnit));
            }

            private O applyTransformation(I i) throws ExecutionException {
                try {
                    return function.apply(i);
                }
                catch (Throwable throwable) {
                    throw new ExecutionException(throwable);
                }
            }
        };
    }

    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), true, MoreExecutors.sameThreadExecutor());
    }

    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new ListFuture(ImmutableList.copyOf(iterable), true, MoreExecutors.sameThreadExecutor());
    }

    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... listenableFutureArray) {
        return new ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), false, MoreExecutors.sameThreadExecutor());
    }

    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> iterable) {
        return new ListFuture(ImmutableList.copyOf(iterable), false, MoreExecutors.sameThreadExecutor());
    }

    public static <V> void addCallback(ListenableFuture<V> listenableFuture, FutureCallback<? super V> futureCallback) {
        Futures.addCallback(listenableFuture, futureCallback, MoreExecutors.sameThreadExecutor());
    }

    public static <V> void addCallback(final ListenableFuture<V> listenableFuture, final FutureCallback<? super V> futureCallback, Executor executor) {
        Preconditions.checkNotNull(futureCallback);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    Object v = Uninterruptibles.getUninterruptibly(listenableFuture);
                    futureCallback.onSuccess(v);
                }
                catch (ExecutionException executionException) {
                    futureCallback.onFailure(executionException.getCause());
                }
                catch (RuntimeException runtimeException) {
                    futureCallback.onFailure(runtimeException);
                }
                catch (Error error) {
                    futureCallback.onFailure(error);
                }
            }
        };
        listenableFuture.addListener(runnable, executor);
    }

    @Beta
    public static <V, X extends Exception> V get(Future<V> future, Class<X> clazz) throws X {
        Preconditions.checkNotNull(future);
        Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(clazz), "Futures.get exception type (%s) must not be a RuntimeException", clazz);
        try {
            return future.get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw Futures.newWithCause(clazz, interruptedException);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowExceptionOrError(executionException.getCause(), clazz);
            throw new AssertionError();
        }
    }

    @Beta
    public static <V, X extends Exception> V get(Future<V> future, long l, TimeUnit timeUnit, Class<X> clazz) throws X {
        Preconditions.checkNotNull(future);
        Preconditions.checkNotNull(timeUnit);
        Preconditions.checkArgument(!RuntimeException.class.isAssignableFrom(clazz), "Futures.get exception type (%s) must not be a RuntimeException", clazz);
        try {
            return future.get(l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw Futures.newWithCause(clazz, interruptedException);
        }
        catch (TimeoutException timeoutException) {
            throw Futures.newWithCause(clazz, timeoutException);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowExceptionOrError(executionException.getCause(), clazz);
            throw new AssertionError();
        }
    }

    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable throwable, Class<X> clazz) throws X {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        if (throwable instanceof RuntimeException) {
            throw new UncheckedExecutionException(throwable);
        }
        throw Futures.newWithCause(clazz, throwable);
    }

    @Beta
    public static <V> V getUnchecked(Future<V> future) {
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(future);
        }
        catch (ExecutionException executionException) {
            Futures.wrapAndThrowUnchecked(executionException.getCause());
            throw new AssertionError();
        }
    }

    private static void wrapAndThrowUnchecked(Throwable throwable) {
        if (throwable instanceof Error) {
            throw new ExecutionError((Error)throwable);
        }
        throw new UncheckedExecutionException(throwable);
    }

    private static <X extends Exception> X newWithCause(Class<X> clazz, Throwable throwable) {
        List<Constructor<X>> list = Arrays.asList(clazz.getConstructors());
        for (Constructor<X> constructor : Futures.preferringStrings(list)) {
            Exception exception = (Exception)Futures.newFromConstructor(constructor, throwable);
            if (exception == null) continue;
            if (exception.getCause() == null) {
                exception.initCause(throwable);
            }
            return (X)exception;
        }
        throw new IllegalArgumentException("No appropriate constructor for exception of type " + clazz + " in response to chained exception", throwable);
    }

    private static <X extends Exception> List<Constructor<X>> preferringStrings(List<Constructor<X>> list) {
        return WITH_STRING_PARAM_FIRST.sortedCopy(list);
    }

    @Nullable
    private static <X> X newFromConstructor(Constructor<X> constructor, Throwable throwable) {
        Class<?>[] classArray = constructor.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (clazz.equals(String.class)) {
                objectArray[i] = throwable.toString();
                continue;
            }
            if (clazz.equals(Throwable.class)) {
                objectArray[i] = throwable;
                continue;
            }
            return null;
        }
        try {
            return constructor.newInstance(objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MappingCheckedFuture<V, X extends Exception>
    extends AbstractCheckedFuture<V, X> {
        final Function<Exception, X> mapper;

        MappingCheckedFuture(ListenableFuture<V> listenableFuture, Function<Exception, X> function) {
            super(listenableFuture);
            this.mapper = Preconditions.checkNotNull(function);
        }

        @Override
        protected X mapException(Exception exception) {
            return (X)((Exception)this.mapper.apply(exception));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListFuture<V>
    extends AbstractFuture<List<V>> {
        ImmutableList<? extends ListenableFuture<? extends V>> futures;
        final boolean allMustSucceed;
        final AtomicInteger remaining;
        List<V> values;

        ListFuture(ImmutableList<? extends ListenableFuture<? extends V>> immutableList, boolean bl, Executor executor) {
            this.futures = immutableList;
            this.values = Lists.newArrayListWithCapacity(immutableList.size());
            this.allMustSucceed = bl;
            this.remaining = new AtomicInteger(immutableList.size());
            this.init(executor);
        }

        private void init(Executor executor) {
            this.addListener(new Runnable(){

                public void run() {
                    ListFuture.this.values = null;
                    ListFuture.this.futures = null;
                }
            }, MoreExecutors.sameThreadExecutor());
            if (this.futures.isEmpty()) {
                this.set(Lists.newArrayList(this.values));
                return;
            }
            for (int i = 0; i < this.futures.size(); ++i) {
                this.values.add(null);
            }
            ImmutableList<ListenableFuture<V>> immutableList = this.futures;
            int n = 0;
            while (n < immutableList.size()) {
                final ListenableFuture listenableFuture = (ListenableFuture)immutableList.get(n);
                final int n2 = n++;
                listenableFuture.addListener(new Runnable(){

                    public void run() {
                        ListFuture.this.setOneValue(n2, listenableFuture);
                    }
                }, executor);
            }
        }

        /*
         * Exception decompiling
         */
        private void setOneValue(int var1_1, Future<? extends V> var2_2) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public List<V> get() throws InterruptedException, ExecutionException {
            this.callAllGets();
            return (List)super.get();
        }

        private void callAllGets() throws InterruptedException {
            ImmutableList<ListenableFuture<V>> immutableList = this.futures;
            if (immutableList != null && !this.isDone()) {
                for (ListenableFuture listenableFuture : immutableList) {
                    while (!listenableFuture.isDone()) {
                        try {
                            listenableFuture.get();
                        }
                        catch (Error error) {
                            throw error;
                        }
                        catch (InterruptedException interruptedException) {
                            throw interruptedException;
                        }
                        catch (Throwable throwable) {
                            if (!this.allMustSucceed) continue;
                            return;
                        }
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChainingListenableFuture<I, O>
    extends AbstractFuture<O>
    implements Runnable {
        private AsyncFunction<? super I, ? extends O> function;
        private ListenableFuture<? extends I> inputFuture;
        private volatile ListenableFuture<? extends O> outputFuture;
        private final BlockingQueue<Boolean> mayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
        private final CountDownLatch outputCreated = new CountDownLatch(1);

        private ChainingListenableFuture(AsyncFunction<? super I, ? extends O> asyncFunction, ListenableFuture<? extends I> listenableFuture) {
            this.function = Preconditions.checkNotNull(asyncFunction);
            this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        }

        @Override
        public O get() throws InterruptedException, ExecutionException {
            if (!this.isDone()) {
                ListenableFuture<I> listenableFuture = this.inputFuture;
                if (listenableFuture != null) {
                    listenableFuture.get();
                }
                this.outputCreated.await();
                ListenableFuture<O> listenableFuture2 = this.outputFuture;
                if (listenableFuture2 != null) {
                    listenableFuture2.get();
                }
            }
            return (O)super.get();
        }

        @Override
        public O get(long l, TimeUnit timeUnit) throws TimeoutException, ExecutionException, InterruptedException {
            if (!this.isDone()) {
                long l2;
                ListenableFuture<I> listenableFuture;
                if (timeUnit != TimeUnit.NANOSECONDS) {
                    l = TimeUnit.NANOSECONDS.convert(l, timeUnit);
                    timeUnit = TimeUnit.NANOSECONDS;
                }
                if ((listenableFuture = this.inputFuture) != null) {
                    l2 = System.nanoTime();
                    listenableFuture.get(l, timeUnit);
                    l -= Math.max(0L, System.nanoTime() - l2);
                }
                l2 = System.nanoTime();
                if (!this.outputCreated.await(l, timeUnit)) {
                    throw new TimeoutException();
                }
                l -= Math.max(0L, System.nanoTime() - l2);
                ListenableFuture<O> listenableFuture2 = this.outputFuture;
                if (listenableFuture2 != null) {
                    listenableFuture2.get(l, timeUnit);
                }
            }
            return (O)super.get(l, timeUnit);
        }

        @Override
        public boolean cancel(boolean bl) {
            if (super.cancel(bl)) {
                Uninterruptibles.putUninterruptibly(this.mayInterruptIfRunningChannel, bl);
                this.cancel(this.inputFuture, bl);
                this.cancel(this.outputFuture, bl);
                return true;
            }
            return false;
        }

        private void cancel(@Nullable Future<?> future, boolean bl) {
            if (future != null) {
                future.cancel(bl);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block16: {
                try {
                    I i;
                    try {
                        i = Uninterruptibles.getUninterruptibly(this.inputFuture);
                    }
                    catch (CancellationException cancellationException) {
                        this.cancel(false);
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    catch (ExecutionException executionException) {
                        this.setException(executionException.getCause());
                        this.function = null;
                        this.inputFuture = null;
                        this.outputCreated.countDown();
                        return;
                    }
                    this.outputFuture = this.function.apply(i);
                    final ListenableFuture<O> listenableFuture = this.outputFuture;
                    if (this.isCancelled()) {
                        listenableFuture.cancel(Uninterruptibles.takeUninterruptibly(this.mayInterruptIfRunningChannel));
                        this.outputFuture = null;
                        return;
                    }
                    listenableFuture.addListener(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ChainingListenableFuture.this.set(Uninterruptibles.getUninterruptibly(listenableFuture));
                            }
                            catch (CancellationException cancellationException) {
                                ChainingListenableFuture.this.cancel(false);
                                return;
                            }
                            catch (ExecutionException executionException) {
                                ChainingListenableFuture.this.setException(executionException.getCause());
                            }
                            finally {
                                ChainingListenableFuture.this.outputFuture = null;
                            }
                        }
                    }, MoreExecutors.sameThreadExecutor());
                    break block16;
                    {
                        catch (UndeclaredThrowableException undeclaredThrowableException) {
                            this.setException(undeclaredThrowableException.getCause());
                            break block16;
                        }
                        catch (Exception exception) {
                            this.setException(exception);
                            break block16;
                        }
                        catch (Error error) {
                            this.setException(error);
                            break block16;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    this.function = null;
                    this.inputFuture = null;
                    this.outputCreated.countDown();
                }
            }
        }
    }
}

