/*
 * Decompiled with CFR 0.152.
 */
package junit.textui;

import java.io.PrintStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.runner.BaseTestRunner;
import junit.runner.Version;
import junit.textui.ResultPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner
extends BaseTestRunner {
    private ResultPrinter fPrinter;
    public static final int SUCCESS_EXIT = 0;
    public static final int FAILURE_EXIT = 1;
    public static final int EXCEPTION_EXIT = 2;

    public TestRunner() {
        this(System.out);
    }

    public TestRunner(PrintStream printStream) {
        this(new ResultPrinter(printStream));
    }

    public TestRunner(ResultPrinter resultPrinter) {
        this.fPrinter = resultPrinter;
    }

    public static void run(Class<? extends TestCase> clazz) {
        TestRunner.run(new TestSuite((Class<?>)clazz));
    }

    public static TestResult run(Test test) {
        TestRunner testRunner = new TestRunner();
        return testRunner.doRun(test);
    }

    public static void runAndWait(Test test) {
        TestRunner testRunner = new TestRunner();
        testRunner.doRun(test, true);
    }

    @Override
    public void testFailed(int n, Test test, Throwable throwable) {
    }

    @Override
    public void testStarted(String string) {
    }

    @Override
    public void testEnded(String string) {
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    public TestResult doRun(Test test) {
        return this.doRun(test, false);
    }

    public TestResult doRun(Test test, boolean bl) {
        TestResult testResult = this.createTestResult();
        testResult.addListener(this.fPrinter);
        long l = System.currentTimeMillis();
        test.run(testResult);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        this.fPrinter.print(testResult, l3);
        this.pause(bl);
        return testResult;
    }

    protected void pause(boolean bl) {
        if (!bl) {
            return;
        }
        this.fPrinter.printWaitPrompt();
        try {
            System.in.read();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        TestRunner testRunner = new TestRunner();
        try {
            TestResult testResult = testRunner.start(stringArray);
            if (!testResult.wasSuccessful()) {
                System.exit(1);
            }
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            System.exit(2);
        }
    }

    public TestResult start(String[] stringArray) throws Exception {
        String string = "";
        String string2 = "";
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-wait")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-c")) {
                string = this.extractClassName(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-m")) {
                String string3 = stringArray[++i];
                int n = string3.lastIndexOf(46);
                string = string3.substring(0, n);
                string2 = string3.substring(n + 1);
                continue;
            }
            if (stringArray[i].equals("-v")) {
                System.err.println("JUnit " + Version.id() + " by Kent Beck and Erich Gamma");
                continue;
            }
            string = stringArray[i];
        }
        if (string.equals("")) {
            throw new Exception("Usage: TestRunner [-wait] testCaseName, where name is the name of the TestCase class");
        }
        try {
            if (!string2.equals("")) {
                return this.runSingleMethod(string, string2, bl);
            }
            Test test = this.getTest(string);
            return this.doRun(test, bl);
        }
        catch (Exception exception) {
            throw new Exception("Could not create and run test suite: " + exception);
        }
    }

    protected TestResult runSingleMethod(String string, String string2, boolean bl) throws Exception {
        Class<TestCase> clazz = this.loadSuiteClass(string).asSubclass(TestCase.class);
        Test test = TestSuite.createTest(clazz, string2);
        return this.doRun(test, bl);
    }

    @Override
    protected void runFailed(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public void setPrinter(ResultPrinter resultPrinter) {
        this.fPrinter = resultPrinter;
    }
}

