/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import org.junit.Assert;

public class ComparisonFailure
extends AssertionError {
    private static final int MAX_CONTEXT_LENGTH = 20;
    private static final long serialVersionUID = 1L;
    private String fExpected;
    private String fActual;

    public ComparisonFailure(String string, String string2, String string3) {
        super((Object)string);
        this.fExpected = string2;
        this.fActual = string3;
    }

    public String getMessage() {
        return new ComparisonCompactor(20, this.fExpected, this.fActual).compact(super.getMessage());
    }

    public String getActual() {
        return this.fActual;
    }

    public String getExpected() {
        return this.fExpected;
    }

    private static class ComparisonCompactor {
        private static final String ELLIPSIS = "...";
        private static final String DELTA_END = "]";
        private static final String DELTA_START = "[";
        private int fContextLength;
        private String fExpected;
        private String fActual;
        private int fPrefix;
        private int fSuffix;

        public ComparisonCompactor(int n, String string, String string2) {
            this.fContextLength = n;
            this.fExpected = string;
            this.fActual = string2;
        }

        private String compact(String string) {
            if (this.fExpected == null || this.fActual == null || this.areStringsEqual()) {
                return Assert.format(string, this.fExpected, this.fActual);
            }
            this.findCommonPrefix();
            this.findCommonSuffix();
            String string2 = this.compactString(this.fExpected);
            String string3 = this.compactString(this.fActual);
            return Assert.format(string, string2, string3);
        }

        private String compactString(String string) {
            String string2 = DELTA_START + string.substring(this.fPrefix, string.length() - this.fSuffix + 1) + DELTA_END;
            if (this.fPrefix > 0) {
                string2 = this.computeCommonPrefix() + string2;
            }
            if (this.fSuffix > 0) {
                string2 = string2 + this.computeCommonSuffix();
            }
            return string2;
        }

        private void findCommonPrefix() {
            this.fPrefix = 0;
            int n = Math.min(this.fExpected.length(), this.fActual.length());
            while (this.fPrefix < n && this.fExpected.charAt(this.fPrefix) == this.fActual.charAt(this.fPrefix)) {
                ++this.fPrefix;
            }
        }

        private void findCommonSuffix() {
            int n = this.fExpected.length() - 1;
            for (int i = this.fActual.length() - 1; i >= this.fPrefix && n >= this.fPrefix && this.fExpected.charAt(n) == this.fActual.charAt(i); --i, --n) {
            }
            this.fSuffix = this.fExpected.length() - n;
        }

        private String computeCommonPrefix() {
            return (this.fPrefix > this.fContextLength ? ELLIPSIS : "") + this.fExpected.substring(Math.max(0, this.fPrefix - this.fContextLength), this.fPrefix);
        }

        private String computeCommonSuffix() {
            int n = Math.min(this.fExpected.length() - this.fSuffix + 1 + this.fContextLength, this.fExpected.length());
            return this.fExpected.substring(this.fExpected.length() - this.fSuffix + 1, n) + (this.fExpected.length() - this.fSuffix + 1 < this.fExpected.length() - this.fContextLength ? ELLIPSIS : "");
        }

        private boolean areStringsEqual() {
            return this.fExpected.equals(this.fActual);
        }
    }
}

