/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.categories;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Categories
extends Suite {
    public Categories(Class<?> clazz, RunnerBuilder runnerBuilder) throws InitializationError {
        super(clazz, runnerBuilder);
        try {
            this.filter(new CategoryFilter(this.getIncludedCategory(clazz), this.getExcludedCategory(clazz)));
        }
        catch (NoTestsRemainException noTestsRemainException) {
            throw new InitializationError(noTestsRemainException);
        }
        this.assertNoCategorizedDescendentsOfUncategorizeableParents(this.getDescription());
    }

    private Class<?> getIncludedCategory(Class<?> clazz) {
        IncludeCategory includeCategory = clazz.getAnnotation(IncludeCategory.class);
        return includeCategory == null ? null : includeCategory.value();
    }

    private Class<?> getExcludedCategory(Class<?> clazz) {
        ExcludeCategory excludeCategory = clazz.getAnnotation(ExcludeCategory.class);
        return excludeCategory == null ? null : excludeCategory.value();
    }

    private void assertNoCategorizedDescendentsOfUncategorizeableParents(Description description) throws InitializationError {
        if (!Categories.canHaveCategorizedChildren(description)) {
            this.assertNoDescendantsHaveCategoryAnnotations(description);
        }
        for (Description description2 : description.getChildren()) {
            this.assertNoCategorizedDescendentsOfUncategorizeableParents(description2);
        }
    }

    private void assertNoDescendantsHaveCategoryAnnotations(Description description) throws InitializationError {
        for (Description description2 : description.getChildren()) {
            if (description2.getAnnotation(Category.class) != null) {
                throw new InitializationError("Category annotations on Parameterized classes are not supported on individual methods.");
            }
            this.assertNoDescendantsHaveCategoryAnnotations(description2);
        }
    }

    private static boolean canHaveCategorizedChildren(Description description) {
        for (Description description2 : description.getChildren()) {
            if (description2.getTestClass() != null) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryFilter
    extends Filter {
        private final Class<?> fIncluded;
        private final Class<?> fExcluded;

        public static CategoryFilter include(Class<?> clazz) {
            return new CategoryFilter(clazz, null);
        }

        public CategoryFilter(Class<?> clazz, Class<?> clazz2) {
            this.fIncluded = clazz;
            this.fExcluded = clazz2;
        }

        @Override
        public String describe() {
            return "category " + this.fIncluded;
        }

        @Override
        public boolean shouldRun(Description description) {
            if (this.hasCorrectCategoryAnnotation(description)) {
                return true;
            }
            for (Description description2 : description.getChildren()) {
                if (!this.shouldRun(description2)) continue;
                return true;
            }
            return false;
        }

        private boolean hasCorrectCategoryAnnotation(Description description) {
            List<Class<?>> list = this.categories(description);
            if (list.isEmpty()) {
                return this.fIncluded == null;
            }
            for (Class<?> clazz : list) {
                if (this.fExcluded == null || !this.fExcluded.isAssignableFrom(clazz)) continue;
                return false;
            }
            for (Class<?> clazz : list) {
                if (this.fIncluded != null && !this.fIncluded.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }

        private List<Class<?>> categories(Description description) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(Arrays.asList(this.directCategories(description)));
            arrayList.addAll(Arrays.asList(this.directCategories(this.parentDescription(description))));
            return arrayList;
        }

        private Description parentDescription(Description description) {
            Class<?> clazz = description.getTestClass();
            if (clazz == null) {
                return null;
            }
            return Description.createSuiteDescription(clazz);
        }

        private Class<?>[] directCategories(Description description) {
            if (description == null) {
                return new Class[0];
            }
            Category category = description.getAnnotation(Category.class);
            if (category == null) {
                return new Class[0];
            }
            return category.value();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ExcludeCategory {
        public Class<?> value();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IncludeCategory {
        public Class<?> value();
    }
}

