/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.results;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.junit.experimental.results.FailureList;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableResult {
    private Result result;

    public static PrintableResult testResult(Class<?> clazz) {
        return PrintableResult.testResult(Request.aClass(clazz));
    }

    public static PrintableResult testResult(Request request) {
        return new PrintableResult(new JUnitCore().run(request));
    }

    public PrintableResult(List<Failure> list) {
        this(new FailureList(list).result());
    }

    private PrintableResult(Result result) {
        this.result = result;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new TextListener(new PrintStream(byteArrayOutputStream)).testRunFinished(this.result);
        return byteArrayOutputStream.toString();
    }

    public int failureCount() {
        return this.result.getFailures().size();
    }
}

