/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.experimental.theories.DataPoint;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.Theory;
import org.junit.experimental.theories.internal.Assignments;
import org.junit.experimental.theories.internal.ParameterizedAssertionError;
import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Theories
extends BlockJUnit4ClassRunner {
    public Theories(Class<?> clazz) throws InitializationError {
        super(clazz);
    }

    @Override
    protected void collectInitializationErrors(List<Throwable> list) {
        super.collectInitializationErrors(list);
        this.validateDataPointFields(list);
    }

    private void validateDataPointFields(List<Throwable> list) {
        Field[] fieldArray;
        for (Field field : fieldArray = this.getTestClass().getJavaClass().getDeclaredFields()) {
            if (field.getAnnotation(DataPoint.class) == null || Modifier.isStatic(field.getModifiers())) continue;
            list.add(new Error("DataPoint field " + field.getName() + " must be static"));
        }
    }

    @Override
    protected void validateConstructor(List<Throwable> list) {
        this.validateOnlyOneConstructor(list);
    }

    @Override
    protected void validateTestMethods(List<Throwable> list) {
        for (FrameworkMethod frameworkMethod : this.computeTestMethods()) {
            if (frameworkMethod.getAnnotation(Theory.class) != null) {
                frameworkMethod.validatePublicVoid(false, list);
                continue;
            }
            frameworkMethod.validatePublicVoidNoArg(false, list);
        }
    }

    @Override
    protected List<FrameworkMethod> computeTestMethods() {
        List<FrameworkMethod> list = super.computeTestMethods();
        List<FrameworkMethod> list2 = this.getTestClass().getAnnotatedMethods(Theory.class);
        list.removeAll(list2);
        list.addAll(list2);
        return list;
    }

    @Override
    public Statement methodBlock(FrameworkMethod frameworkMethod) {
        return new TheoryAnchor(frameworkMethod, this.getTestClass());
    }

    public static class TheoryAnchor
    extends Statement {
        private int successes = 0;
        private FrameworkMethod fTestMethod;
        private TestClass fTestClass;
        private List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();

        public TheoryAnchor(FrameworkMethod frameworkMethod, TestClass testClass) {
            this.fTestMethod = frameworkMethod;
            this.fTestClass = testClass;
        }

        private TestClass getTestClass() {
            return this.fTestClass;
        }

        public void evaluate() throws Throwable {
            this.runWithAssignment(Assignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass()));
            if (this.successes == 0) {
                Assert.fail("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters);
            }
        }

        protected void runWithAssignment(Assignments assignments) throws Throwable {
            if (!assignments.isComplete()) {
                this.runWithIncompleteAssignment(assignments);
            } else {
                this.runWithCompleteAssignment(assignments);
            }
        }

        protected void runWithIncompleteAssignment(Assignments assignments) throws InstantiationException, IllegalAccessException, Throwable {
            for (PotentialAssignment potentialAssignment : assignments.potentialsForNextUnassigned()) {
                this.runWithAssignment(assignments.assignNext(potentialAssignment));
            }
        }

        protected void runWithCompleteAssignment(final Assignments assignments) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, Throwable {
            new BlockJUnit4ClassRunner(this.getTestClass().getJavaClass()){

                @Override
                protected void collectInitializationErrors(List<Throwable> list) {
                }

                @Override
                public Statement methodBlock(FrameworkMethod frameworkMethod) {
                    final Statement statement = super.methodBlock(frameworkMethod);
                    return new Statement(){

                        public void evaluate() throws Throwable {
                            try {
                                statement.evaluate();
                                TheoryAnchor.this.handleDataPointSuccess();
                            }
                            catch (AssumptionViolatedException assumptionViolatedException) {
                                TheoryAnchor.this.handleAssumptionViolation(assumptionViolatedException);
                            }
                            catch (Throwable throwable) {
                                TheoryAnchor.this.reportParameterizedError(throwable, assignments.getArgumentStrings(TheoryAnchor.this.nullsOk()));
                            }
                        }
                    };
                }

                @Override
                protected Statement methodInvoker(FrameworkMethod frameworkMethod, Object object) {
                    return TheoryAnchor.this.methodCompletesWithParameters(frameworkMethod, assignments, object);
                }

                @Override
                public Object createTest() throws Exception {
                    return this.getTestClass().getOnlyConstructor().newInstance(assignments.getConstructorArguments(TheoryAnchor.this.nullsOk()));
                }
            }.methodBlock(this.fTestMethod).evaluate();
        }

        private Statement methodCompletesWithParameters(final FrameworkMethod frameworkMethod, final Assignments assignments, final Object object) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    try {
                        Object[] objectArray = assignments.getMethodArguments(TheoryAnchor.this.nullsOk());
                        frameworkMethod.invokeExplosively(object, objectArray);
                    }
                    catch (PotentialAssignment.CouldNotGenerateValueException couldNotGenerateValueException) {
                        // empty catch block
                    }
                }
            };
        }

        protected void handleAssumptionViolation(AssumptionViolatedException assumptionViolatedException) {
            this.fInvalidParameters.add(assumptionViolatedException);
        }

        protected void reportParameterizedError(Throwable throwable, Object ... objectArray) throws Throwable {
            if (objectArray.length == 0) {
                throw throwable;
            }
            throw new ParameterizedAssertionError(throwable, this.fTestMethod.getName(), objectArray);
        }

        private boolean nullsOk() {
            Theory theory = this.fTestMethod.getMethod().getAnnotation(Theory.class);
            if (theory == null) {
                return false;
            }
            return theory.nullsAccepted();
        }

        protected void handleDataPointSuccess() {
            ++this.successes;
        }
    }
}

