/*
 * Decompiled with CFR 0.152.
 */
package org.junit.experimental.theories.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.experimental.theories.ParameterSignature;
import org.junit.experimental.theories.ParameterSupplier;
import org.junit.experimental.theories.ParametersSuppliedBy;
import org.junit.experimental.theories.PotentialAssignment;
import org.junit.experimental.theories.internal.AllMembersSupplier;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Assignments {
    private List<PotentialAssignment> fAssigned;
    private final List<ParameterSignature> fUnassigned;
    private final TestClass fClass;

    private Assignments(List<PotentialAssignment> list, List<ParameterSignature> list2, TestClass testClass) {
        this.fUnassigned = list2;
        this.fAssigned = list;
        this.fClass = testClass;
    }

    public static Assignments allUnassigned(Method method, TestClass testClass) throws Exception {
        List<ParameterSignature> list = ParameterSignature.signatures(testClass.getOnlyConstructor());
        list.addAll(ParameterSignature.signatures(method));
        return new Assignments(new ArrayList<PotentialAssignment>(), list, testClass);
    }

    public boolean isComplete() {
        return this.fUnassigned.size() == 0;
    }

    public ParameterSignature nextUnassigned() {
        return this.fUnassigned.get(0);
    }

    public Assignments assignNext(PotentialAssignment potentialAssignment) {
        ArrayList<PotentialAssignment> arrayList = new ArrayList<PotentialAssignment>(this.fAssigned);
        arrayList.add(potentialAssignment);
        return new Assignments(arrayList, this.fUnassigned.subList(1, this.fUnassigned.size()), this.fClass);
    }

    public Object[] getActualValues(int n, int n2, boolean bl) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] objectArray = new Object[n2 - n];
        for (int i = n; i < n2; ++i) {
            Object object = this.fAssigned.get(i).getValue();
            if (object == null && !bl) {
                throw new PotentialAssignment.CouldNotGenerateValueException();
            }
            objectArray[i - n] = object;
        }
        return objectArray;
    }

    public List<PotentialAssignment> potentialsForNextUnassigned() throws InstantiationException, IllegalAccessException {
        ParameterSignature parameterSignature = this.nextUnassigned();
        return this.getSupplier(parameterSignature).getValueSources(parameterSignature);
    }

    public ParameterSupplier getSupplier(ParameterSignature parameterSignature) throws InstantiationException, IllegalAccessException {
        ParameterSupplier parameterSupplier = this.getAnnotatedSupplier(parameterSignature);
        if (parameterSupplier != null) {
            return parameterSupplier;
        }
        return new AllMembersSupplier(this.fClass);
    }

    public ParameterSupplier getAnnotatedSupplier(ParameterSignature parameterSignature) throws InstantiationException, IllegalAccessException {
        ParametersSuppliedBy parametersSuppliedBy = parameterSignature.findDeepAnnotation(ParametersSuppliedBy.class);
        if (parametersSuppliedBy == null) {
            return null;
        }
        return parametersSuppliedBy.value().newInstance();
    }

    public Object[] getConstructorArguments(boolean bl) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.getConstructorParameterCount(), bl);
    }

    public Object[] getMethodArguments(boolean bl) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(this.getConstructorParameterCount(), this.fAssigned.size(), bl);
    }

    public Object[] getAllArguments(boolean bl) throws PotentialAssignment.CouldNotGenerateValueException {
        return this.getActualValues(0, this.fAssigned.size(), bl);
    }

    private int getConstructorParameterCount() {
        List<ParameterSignature> list = ParameterSignature.signatures(this.fClass.getOnlyConstructor());
        int n = list.size();
        return n;
    }

    public Object[] getArgumentStrings(boolean bl) throws PotentialAssignment.CouldNotGenerateValueException {
        Object[] objectArray = new Object[this.fAssigned.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.fAssigned.get(i).getDescription();
        }
        return objectArray;
    }
}

