/*
 * Decompiled with CFR 0.152.
 */
package org.junit.rules;

import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public abstract class TestWatcher
implements TestRule {
    public Statement apply(final Statement statement, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                TestWatcher.this.starting(description);
                try {
                    statement.evaluate();
                    TestWatcher.this.succeeded(description);
                }
                catch (AssumptionViolatedException assumptionViolatedException) {
                    throw assumptionViolatedException;
                }
                catch (Throwable throwable) {
                    TestWatcher.this.failed(throwable, description);
                    throw throwable;
                }
                finally {
                    TestWatcher.this.finished(description);
                }
            }
        };
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable throwable, Description description) {
    }

    protected void starting(Description description) {
    }

    protected void finished(Description description) {
    }
}

