/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parameterized
extends Suite {
    private final ArrayList<Runner> runners = new ArrayList();

    public Parameterized(Class<?> clazz) throws Throwable {
        super(clazz, Collections.<Runner>emptyList());
        List<Object[]> list = this.getParametersList(this.getTestClass());
        for (int i = 0; i < list.size(); ++i) {
            this.runners.add(new TestClassRunnerForParameters(this.getTestClass().getJavaClass(), list, i));
        }
    }

    @Override
    protected List<Runner> getChildren() {
        return this.runners;
    }

    private List<Object[]> getParametersList(TestClass testClass) throws Throwable {
        return (List)this.getParametersMethod(testClass).invokeExplosively(null, new Object[0]);
    }

    private FrameworkMethod getParametersMethod(TestClass testClass) throws Exception {
        List<FrameworkMethod> list = testClass.getAnnotatedMethods(Parameters.class);
        for (FrameworkMethod frameworkMethod : list) {
            int n = frameworkMethod.getMethod().getModifiers();
            if (!Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
            return frameworkMethod;
        }
        throw new Exception("No public static parameters method on class " + testClass.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TestClassRunnerForParameters
    extends BlockJUnit4ClassRunner {
        private final int fParameterSetNumber;
        private final List<Object[]> fParameterList;

        TestClassRunnerForParameters(Class<?> clazz, List<Object[]> list, int n) throws InitializationError {
            super(clazz);
            this.fParameterList = list;
            this.fParameterSetNumber = n;
        }

        @Override
        public Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.computeParams());
        }

        private Object[] computeParams() throws Exception {
            try {
                return this.fParameterList.get(this.fParameterSetNumber);
            }
            catch (ClassCastException classCastException) {
                throw new Exception(String.format("%s.%s() must return a Collection of arrays.", this.getTestClass().getName(), Parameterized.this.getParametersMethod(this.getTestClass()).getName()));
            }
        }

        @Override
        protected String getName() {
            return String.format("[%s]", this.fParameterSetNumber);
        }

        @Override
        protected String testName(FrameworkMethod frameworkMethod) {
            return String.format("%s[%s]", frameworkMethod.getName(), this.fParameterSetNumber);
        }

        @Override
        protected void validateConstructor(List<Throwable> list) {
            this.validateOnlyOneConstructor(list);
        }

        @Override
        protected Statement classBlock(RunNotifier runNotifier) {
            return this.childrenInvoker(runNotifier);
        }

        @Override
        protected Annotation[] getRunnerAnnotations() {
            return new Annotation[0];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Parameters {
    }
}

