/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMember;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestClass {
    private final Class<?> fClass;
    private Map<Class<?>, List<FrameworkMethod>> fMethodsForAnnotations = new HashMap();
    private Map<Class<?>, List<FrameworkField>> fFieldsForAnnotations = new HashMap();

    public TestClass(Class<?> clazz) {
        this.fClass = clazz;
        if (clazz != null && clazz.getConstructors().length > 1) {
            throw new IllegalArgumentException("Test class can only have one constructor");
        }
        for (Class<?> clazz2 : this.getSuperClasses(this.fClass)) {
            for (Method method : clazz2.getDeclaredMethods()) {
                this.addToAnnotationLists(new FrameworkMethod(method), this.fMethodsForAnnotations);
            }
            for (AccessibleObject accessibleObject : clazz2.getDeclaredFields()) {
                this.addToAnnotationLists(new FrameworkField((Field)accessibleObject), this.fFieldsForAnnotations);
            }
        }
    }

    private <T extends FrameworkMember<T>> void addToAnnotationLists(T object, Map<Class<?>, List<T>> map) {
        for (Annotation annotation : ((FrameworkMember)object).getAnnotations()) {
            Class<? extends Annotation> clazz = annotation.annotationType();
            List<T> list = this.getAnnotatedMembers(map, clazz);
            if (((FrameworkMember)object).isShadowedBy(list)) {
                return;
            }
            if (this.runsTopToBottom(clazz)) {
                list.add(0, object);
                continue;
            }
            list.add(object);
        }
    }

    public List<FrameworkMethod> getAnnotatedMethods(Class<? extends Annotation> clazz) {
        return this.getAnnotatedMembers(this.fMethodsForAnnotations, clazz);
    }

    public List<FrameworkField> getAnnotatedFields(Class<? extends Annotation> clazz) {
        return this.getAnnotatedMembers(this.fFieldsForAnnotations, clazz);
    }

    private <T> List<T> getAnnotatedMembers(Map<Class<?>, List<T>> map, Class<? extends Annotation> clazz) {
        if (!map.containsKey(clazz)) {
            map.put(clazz, new ArrayList());
        }
        return map.get(clazz);
    }

    private boolean runsTopToBottom(Class<? extends Annotation> clazz) {
        return clazz.equals(Before.class) || clazz.equals(BeforeClass.class);
    }

    private List<Class<?>> getSuperClasses(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            arrayList.add(clazz2);
        }
        return arrayList;
    }

    public Class<?> getJavaClass() {
        return this.fClass;
    }

    public String getName() {
        if (this.fClass == null) {
            return "null";
        }
        return this.fClass.getName();
    }

    public Constructor<?> getOnlyConstructor() {
        Constructor<?>[] constructorArray = this.fClass.getConstructors();
        Assert.assertEquals(1L, constructorArray.length);
        return constructorArray[0];
    }

    public Annotation[] getAnnotations() {
        if (this.fClass == null) {
            return new Annotation[0];
        }
        return this.fClass.getAnnotations();
    }

    public <T> List<T> getAnnotatedFieldValues(Object object, Class<? extends Annotation> clazz, Class<T> clazz2) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (FrameworkField frameworkField : this.getAnnotatedFields(clazz)) {
            try {
                Object object2 = frameworkField.get(object);
                if (!clazz2.isInstance(object2)) continue;
                arrayList.add(clazz2.cast(object2));
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException("How did getFields return a field we couldn't access?", illegalAccessException);
            }
        }
        return arrayList;
    }

    public boolean isANonStaticInnerClass() {
        return this.fClass.isMemberClass() && !Modifier.isStatic(this.fClass.getModifiers());
    }
}

