/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.rules;

import java.lang.annotation.Annotation;
import java.util.List;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RuleFieldValidator {
    CLASS_RULE_VALIDATOR(ClassRule.class, true),
    RULE_VALIDATOR(Rule.class, false);

    private final Class<? extends Annotation> fAnnotation;
    private final boolean fOnlyStaticFields;

    private RuleFieldValidator(Class<? extends Annotation> clazz, boolean bl) {
        this.fAnnotation = clazz;
        this.fOnlyStaticFields = bl;
    }

    public void validate(TestClass testClass, List<Throwable> list) {
        List<FrameworkField> list2 = testClass.getAnnotatedFields(this.fAnnotation);
        for (FrameworkField frameworkField : list2) {
            this.validateField(frameworkField, list);
        }
    }

    private void validateField(FrameworkField frameworkField, List<Throwable> list) {
        this.optionallyValidateStatic(frameworkField, list);
        this.validatePublic(frameworkField, list);
        this.validateTestRuleOrMethodRule(frameworkField, list);
    }

    private void optionallyValidateStatic(FrameworkField frameworkField, List<Throwable> list) {
        if (this.fOnlyStaticFields && !frameworkField.isStatic()) {
            this.addError(list, frameworkField, "must be static.");
        }
    }

    private void validatePublic(FrameworkField frameworkField, List<Throwable> list) {
        if (!frameworkField.isPublic()) {
            this.addError(list, frameworkField, "must be public.");
        }
    }

    private void validateTestRuleOrMethodRule(FrameworkField frameworkField, List<Throwable> list) {
        if (!this.isMethodRule(frameworkField) && !this.isTestRule(frameworkField)) {
            this.addError(list, frameworkField, "must implement MethodRule or TestRule.");
        }
    }

    private boolean isTestRule(FrameworkField frameworkField) {
        return TestRule.class.isAssignableFrom(frameworkField.getType());
    }

    private boolean isMethodRule(FrameworkField frameworkField) {
        return MethodRule.class.isAssignableFrom(frameworkField.getType());
    }

    private void addError(List<Throwable> list, FrameworkField frameworkField, String string) {
        String string2 = "The @" + this.fAnnotation.getSimpleName() + " '" + frameworkField.getName() + "' " + string;
        list.add(new Exception(string2));
    }
}

