/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runner.notification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.StoppedByUserException;

public class RunNotifier {
    private final List<RunListener> fListeners = Collections.synchronizedList(new ArrayList());
    private boolean fPleaseStop = false;

    public void addListener(RunListener runListener) {
        this.fListeners.add(runListener);
    }

    public void removeListener(RunListener runListener) {
        this.fListeners.remove(runListener);
    }

    public void fireTestRunStarted(final Description description) {
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testRunStarted(description);
            }
        }.run();
    }

    public void fireTestRunFinished(final Result result) {
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testRunFinished(result);
            }
        }.run();
    }

    public void fireTestStarted(final Description description) throws StoppedByUserException {
        if (this.fPleaseStop) {
            throw new StoppedByUserException();
        }
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testStarted(description);
            }
        }.run();
    }

    public void fireTestFailure(final Failure failure) {
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testFailure(failure);
            }
        }.run();
    }

    public void fireTestAssumptionFailed(final Failure failure) {
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testAssumptionFailure(failure);
            }
        }.run();
    }

    public void fireTestIgnored(final Description description) {
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testIgnored(description);
            }
        }.run();
    }

    public void fireTestFinished(final Description description) {
        new SafeNotifier(){

            protected void notifyListener(RunListener runListener) throws Exception {
                runListener.testFinished(description);
            }
        }.run();
    }

    public void pleaseStop() {
        this.fPleaseStop = true;
    }

    public void addFirstListener(RunListener runListener) {
        this.fListeners.add(0, runListener);
    }

    private abstract class SafeNotifier {
        private SafeNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void run() {
            List list = RunNotifier.this.fListeners;
            synchronized (list) {
                Iterator iterator = RunNotifier.this.fListeners.iterator();
                while (iterator.hasNext()) {
                    try {
                        this.notifyListener((RunListener)iterator.next());
                    }
                    catch (Exception exception) {
                        iterator.remove();
                        RunNotifier.this.fireTestFailure(new Failure(Description.TEST_MECHANISM, exception));
                    }
                }
            }
        }

        protected abstract void notifyListener(RunListener var1) throws Exception;
    }
}

