/*
 * Decompiled with CFR 0.152.
 */
package org.junit.runners.model;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NoGenericTypeParametersValidator {
    private final Method fMethod;

    NoGenericTypeParametersValidator(Method method) {
        this.fMethod = method;
    }

    void validate(List<Throwable> list) {
        for (Type type : this.fMethod.getGenericParameterTypes()) {
            this.validateNoTypeParameterOnType(type, list);
        }
    }

    private void validateNoTypeParameterOnType(Type type, List<Throwable> list) {
        if (type instanceof TypeVariable) {
            list.add(new Exception("Method " + this.fMethod.getName() + "() contains unresolved type variable " + type));
        } else if (type instanceof ParameterizedType) {
            this.validateNoTypeParameterOnParameterizedType((ParameterizedType)type, list);
        } else if (type instanceof WildcardType) {
            this.validateNoTypeParameterOnWildcardType((WildcardType)type, list);
        } else if (type instanceof GenericArrayType) {
            this.validateNoTypeParameterOnGenericArrayType((GenericArrayType)type, list);
        }
    }

    private void validateNoTypeParameterOnParameterizedType(ParameterizedType parameterizedType, List<Throwable> list) {
        for (Type type : parameterizedType.getActualTypeArguments()) {
            this.validateNoTypeParameterOnType(type, list);
        }
    }

    private void validateNoTypeParameterOnWildcardType(WildcardType wildcardType, List<Throwable> list) {
        for (Type type : wildcardType.getUpperBounds()) {
            this.validateNoTypeParameterOnType(type, list);
        }
        for (Type type : wildcardType.getLowerBounds()) {
            this.validateNoTypeParameterOnType(type, list);
        }
    }

    private void validateNoTypeParameterOnGenericArrayType(GenericArrayType genericArrayType, List<Throwable> list) {
        this.validateNoTypeParameterOnType(genericArrayType.getGenericComponentType(), list);
    }
}

