/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.build;

import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import java.io.File;
import java.io.FileNotFoundException;

public class CtsBuildHelper {
    static final String CTS_DIR_NAME = "android-cts";
    private final File mRootDir;
    private final File mCtsDir;

    public CtsBuildHelper(File file) {
        this.mRootDir = file;
        this.mCtsDir = new File(this.mRootDir, CTS_DIR_NAME);
    }

    public CtsBuildHelper(IFolderBuildInfo iFolderBuildInfo) throws FileNotFoundException {
        this(iFolderBuildInfo.getRootDir());
    }

    public static CtsBuildHelper createBuildHelper(IBuildInfo iBuildInfo) {
        if (!(iBuildInfo instanceof IFolderBuildInfo)) {
            throw new IllegalArgumentException(String.format("Wrong build type. Expected %s, received %s", IFolderBuildInfo.class.getName(), iBuildInfo.getClass().getName()));
        }
        try {
            CtsBuildHelper ctsBuildHelper = new CtsBuildHelper((IFolderBuildInfo)iBuildInfo);
            ctsBuildHelper.validateStructure();
            return ctsBuildHelper;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("Invalid CTS build provided.", fileNotFoundException);
        }
    }

    public File getRootDir() {
        return this.mRootDir;
    }

    public File getCtsDir() {
        return this.mCtsDir;
    }

    public File getTestApp(String string) throws FileNotFoundException {
        File file = new File(this.getTestCasesDir(), string);
        if (!file.exists()) {
            throw new FileNotFoundException(String.format("CTS test app file %s does not exist", file.getAbsolutePath()));
        }
        return file;
    }

    private File getRepositoryDir() {
        return new File(this.getCtsDir(), "repository");
    }

    public File getResultsDir() {
        return new File(this.getRepositoryDir(), "results");
    }

    public File getLogsDir() {
        return new File(this.getRepositoryDir(), "logs");
    }

    public File getTestCasesDir() {
        return new File(this.getRepositoryDir(), "testcases");
    }

    public File getTestPlansDir() {
        return new File(this.getRepositoryDir(), "plans");
    }

    public File getTestPlanFile(String string) throws FileNotFoundException {
        String string2 = String.format("%s.xml", string);
        return new File(this.getTestPlansDir(), string2);
    }

    public void validateStructure() throws FileNotFoundException {
        if (!this.getCtsDir().exists()) {
            throw new FileNotFoundException(String.format("CTS install folder %s does not exist", this.getCtsDir().getAbsolutePath()));
        }
        if (!this.getTestCasesDir().exists()) {
            throw new FileNotFoundException(String.format("CTS test cases folder %s does not exist", this.getTestCasesDir().getAbsolutePath()));
        }
        if (!this.getTestPlansDir().exists()) {
            throw new FileNotFoundException(String.format("CTS test plans folder %s does not exist", this.getTestPlansDir().getAbsolutePath()));
        }
    }
}

