/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.command;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.result.ITestSummary;
import com.android.cts.tradefed.result.PlanCreator;
import com.android.cts.tradefed.result.TestResultRepo;
import com.android.cts.tradefed.testtype.TestPackageRepo;
import com.android.tradefed.command.Console;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.RegexTrie;
import com.android.tradefed.util.TableFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtsConsole
extends Console {
    protected static final String ADD_PATTERN = "a(?:dd)?";
    private CtsBuildHelper mCtsBuild = null;

    CtsConsole() {
    }

    public void run() {
        this.printLine(String.format("Android CTS %s", "4.1_r4"));
        super.run();
    }

    protected void setCustomCommands(RegexTrie<Runnable> regexTrie, List<String> list, Map<String, String> map) {
        regexTrie.put((Object)new Runnable(){

            public void run() {
                CtsBuildHelper ctsBuildHelper = CtsConsole.this.getCtsBuild();
                if (ctsBuildHelper != null) {
                    CtsConsole.this.listPlans(ctsBuildHelper);
                }
            }
        }, new String[]{"l(?:ist)?", "p(?:lans)?"});
        regexTrie.put((Object)new Runnable(){

            public void run() {
                CtsBuildHelper ctsBuildHelper = CtsConsole.this.getCtsBuild();
                if (ctsBuildHelper != null) {
                    CtsConsole.this.listPackages(ctsBuildHelper);
                }
            }
        }, new String[]{"l(?:ist)?", "packages"});
        regexTrie.put((Object)new Runnable(){

            public void run() {
                CtsBuildHelper ctsBuildHelper = CtsConsole.this.getCtsBuild();
                if (ctsBuildHelper != null) {
                    CtsConsole.this.listResults(ctsBuildHelper);
                }
            }
        }, new String[]{"l(?:ist)?", "r(?:esults)?"});
        String string = map.get("l(?:ist)?");
        if (string == null) {
            string = new String();
        }
        String string2 = string + "\tp[lans]\t\tList all CTS test plans" + LINE_SEPARATOR + "\tpackages\tList all CTS packages" + LINE_SEPARATOR + "\tr[esults]\tList all CTS results" + LINE_SEPARATOR;
        map.put("l(?:ist)?", string2);
        Console.ArgRunnable<Console.CaptureList> argRunnable = new Console.ArgRunnable<Console.CaptureList>(){

            public void run(Console.CaptureList captureList) {
                String[] stringArray = new String[captureList.size() - 2];
                for (int i = 2; i < captureList.size(); ++i) {
                    stringArray[i - 2] = (String)((List)captureList.get(i)).get(0);
                }
                CtsBuildHelper ctsBuildHelper = CtsConsole.this.getCtsBuild();
                if (ctsBuildHelper != null) {
                    CtsConsole.this.addDerivedPlan(ctsBuildHelper, stringArray);
                }
            }
        };
        regexTrie.put((Object)argRunnable, new String[]{ADD_PATTERN, "d(?:erivedplan?)", null});
        map.put(ADD_PATTERN, String.format("%s help:" + LINE_SEPARATOR + "\tderivedplan      Add a derived plan" + LINE_SEPARATOR, ADD_PATTERN));
    }

    protected String getConsolePrompt() {
        return "cts-tf > ";
    }

    protected String getGenericHelpString(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CTS-tradefed host version ");
        stringBuilder.append("4.1_r4");
        stringBuilder.append("\n\n");
        stringBuilder.append("CTS-tradefed is the test harness for running the Android ");
        stringBuilder.append("Compatibility Suite, built on top of the tradefed framework.\n\n");
        stringBuilder.append("Available commands and options\n");
        stringBuilder.append("Host:\n");
        stringBuilder.append("  help: show this message\n");
        stringBuilder.append("  help all: show the complete tradefed help\n");
        stringBuilder.append("  exit: gracefully exit the cts console, waiting till all ");
        stringBuilder.append("invocations are complete\n");
        stringBuilder.append("Run:\n");
        stringBuilder.append("  run cts --plan test_plan_name: run a test plan\n");
        stringBuilder.append("  run cts --package/-p : run a CTS test package\n");
        stringBuilder.append("  run cts --class/-c [--method/-m] : run a specific test class and/or");
        stringBuilder.append("method\n");
        stringBuilder.append("  run cts --continue-session session_ID: run all not executed ");
        stringBuilder.append("tests from a previous CTS session\n");
        stringBuilder.append("  run cts [options] --serial/s device_ID: run CTS on specified ");
        stringBuilder.append("device\n");
        stringBuilder.append("  run cts [options] --shards number_of_shards: shard a CTS run into ");
        stringBuilder.append("given number of independent chunks, to run on multiple devices in");
        stringBuilder.append("parallel\n");
        stringBuilder.append("  run cts --help/--help-all: get more help on running CTS\n");
        stringBuilder.append("List:\n");
        stringBuilder.append("  l/list d/devices: list connected devices and their state\n");
        stringBuilder.append("  l/list packages: list CTS test packages\n");
        stringBuilder.append("  l/list p/plans: list CTS test plans\n");
        stringBuilder.append("  l/list i/invocations: list invocations aka CTS test runs currently");
        stringBuilder.append("in progress\n");
        stringBuilder.append("  l/list c/commands: list commands: aka CTS test run commands ");
        stringBuilder.append("currently in the queue waiting to be allocated devices\n");
        stringBuilder.append("  l/list r/results: list CTS results currently present in the ");
        stringBuilder.append("repository\n");
        stringBuilder.append("Add:\n");
        stringBuilder.append("  add derivedplan --plan plane_name --session/-s session_id -r ");
        stringBuilder.append("[pass/fail/notExecuted/timeout]: derive a plan from the given ");
        stringBuilder.append("session\n");
        stringBuilder.append("Dump:\n");
        stringBuilder.append("  d/dump l/logs: dump the tradefed logs for all running invocations\n");
        stringBuilder.append("Options:\n");
        stringBuilder.append("  --disable-reboot : Do not reboot device after running some amount of tests.\n");
        return stringBuilder.toString();
    }

    private void listPlans(CtsBuildHelper ctsBuildHelper) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xml");
            }
        };
        for (File file : ctsBuildHelper.getTestPlansDir().listFiles(filenameFilter)) {
            this.printLine(FileUtil.getBaseName((String)file.getName()));
        }
    }

    private void listPackages(CtsBuildHelper ctsBuildHelper) {
        TestPackageRepo testPackageRepo = new TestPackageRepo(ctsBuildHelper.getTestCasesDir(), false);
        for (String string : testPackageRepo.getPackageNames()) {
            this.printLine(string);
        }
    }

    private void listResults(CtsBuildHelper ctsBuildHelper) {
        TableFormatter tableFormatter = new TableFormatter();
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        arrayList.add(Arrays.asList("Session", "Pass", "Fail", "Not Executed", "Start time", "Plan name", "Device serial(s)"));
        TestResultRepo testResultRepo = new TestResultRepo(ctsBuildHelper.getResultsDir());
        for (ITestSummary iTestSummary : testResultRepo.getSummaries()) {
            arrayList.add(Arrays.asList(Integer.toString(iTestSummary.getId()), Integer.toString(iTestSummary.getNumPassed()), Integer.toString(iTestSummary.getNumFailed()), Integer.toString(iTestSummary.getNumIncomplete()), iTestSummary.getTimestamp(), iTestSummary.getTestPlan(), iTestSummary.getDeviceSerials()));
        }
        tableFormatter.displayTable(arrayList, new PrintWriter(System.out, true));
    }

    private void addDerivedPlan(CtsBuildHelper ctsBuildHelper, String[] stringArray) {
        PlanCreator planCreator = new PlanCreator();
        try {
            ArgsOptionParser argsOptionParser = new ArgsOptionParser(new Object[]{planCreator});
            argsOptionParser.parse(Arrays.asList(stringArray));
            planCreator.createAndSerializeDerivedPlan(ctsBuildHelper);
        }
        catch (ConfigurationException configurationException) {
            this.printLine("Error: " + configurationException.getMessage());
            this.printLine(ArgsOptionParser.getOptionHelp((boolean)false, (Object)planCreator));
        }
    }

    private CtsBuildHelper getCtsBuild() {
        if (this.mCtsBuild == null) {
            String string = System.getProperty("CTS_ROOT");
            if (string != null) {
                this.mCtsBuild = new CtsBuildHelper(new File(string));
                try {
                    this.mCtsBuild.validateStructure();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.printLine(String.format("Invalid cts install: %s", fileNotFoundException.getMessage()));
                    this.mCtsBuild = null;
                }
            } else {
                this.printLine("Could not find CTS install location: CTS_ROOT env variable not set");
            }
        }
        return this.mCtsBuild;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        CtsConsole ctsConsole = new CtsConsole();
        Console.startConsole((Console)ctsConsole, (String[])stringArray);
    }
}

