/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.ResultReporter;
import com.android.cts.tradefed.result.Test;
import com.android.cts.tradefed.result.TestPackageResult;
import com.android.cts.tradefed.result.TestResultRepo;
import com.android.cts.tradefed.result.TestResults;
import com.android.cts.tradefed.result.TimeUtil;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.build.IFolderBuildInfo;
import com.android.tradefed.config.Option;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ILogFileSaver;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.InputStreamSource;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.LogFileSaver;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.StreamUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CtsXmlResultReporter
implements ITestInvocationListener {
    private static final String LOG_TAG = "CtsXmlResultReporter";
    static final String TEST_RESULT_FILE_NAME = "testResult.xml";
    private static final String CTS_RESULT_FILE_VERSION = "1.13";
    private static final String[] CTS_RESULT_RESOURCES = new String[]{"cts_result.xsl", "cts_result.css", "logo.gif", "newrule-green.png"};
    static final String ns = null;
    static final String RESULT_TAG = "TestResult";
    static final String PLAN_ATTR = "testPlan";
    static final String STARTTIME_ATTR = "starttime";
    private static final String REPORT_DIR_NAME = "output-file-path";
    @Option(name="output-file-path", description="root file system path to directory to store xml test results and associated logs. If not specified, results will be stored at <cts root>/repository/results")
    protected File mReportDir = null;
    @Option(name="plan", description="the test plan to run.")
    private String mPlanName = "NA";
    @Option(name="continue-session", description="the test result session to continue.")
    private Integer mContinueSessionId = null;
    @Option(name="quiet-output", description="Mute display of test results.")
    private boolean mQuietOutput = false;
    @Option(name="result-server", description="Server to publish test results.")
    private String mResultServer;
    protected IBuildInfo mBuildInfo;
    private String mStartTime;
    private String mDeviceSerial;
    private TestResults mResults = new TestResults();
    private TestPackageResult mCurrentPkgResult = null;
    private boolean mIsDeviceInfoRun = false;
    private File mLogDir;

    public void setReportDir(File file) {
        this.mReportDir = file;
    }

    public void invocationStarted(IBuildInfo iBuildInfo) {
        Object object;
        this.mBuildInfo = iBuildInfo;
        if (!(iBuildInfo instanceof IFolderBuildInfo)) {
            throw new IllegalArgumentException("build info is not a IFolderBuildInfo");
        }
        IFolderBuildInfo iFolderBuildInfo = (IFolderBuildInfo)iBuildInfo;
        String string = this.mDeviceSerial = iBuildInfo.getDeviceSerial() == null ? "unknown_device" : iBuildInfo.getDeviceSerial();
        if (this.mContinueSessionId != null) {
            LogUtil.CLog.d((String)"Continuing session %d", (Object[])new Object[]{this.mContinueSessionId});
            object = new TestResultRepo(this.getBuildHelper(iFolderBuildInfo).getResultsDir());
            this.mResults = ((TestResultRepo)object).getResult(this.mContinueSessionId);
            if (this.mResults == null) {
                throw new IllegalArgumentException(String.format("Could not find session %d", this.mContinueSessionId));
            }
            this.mPlanName = ((TestResultRepo)object).getSummaries().get(this.mContinueSessionId).getTestPlan();
            this.mStartTime = ((TestResultRepo)object).getSummaries().get(this.mContinueSessionId).getStartTime();
            this.mReportDir = ((TestResultRepo)object).getReportDir(this.mContinueSessionId);
        } else {
            if (this.mReportDir == null) {
                this.mReportDir = this.getBuildHelper(iFolderBuildInfo).getResultsDir();
            }
            this.mReportDir = new File(this.mReportDir, TimeUtil.getResultTimestamp());
            this.mReportDir.mkdirs();
            this.mStartTime = this.getTimestamp();
            this.logResult("Created result dir %s", this.mReportDir.getName());
        }
        object = this.getBuildHelper(iFolderBuildInfo).getLogsDir();
        this.mLogDir = new File((File)object, this.mReportDir.getName());
        this.mLogDir.mkdirs();
    }

    CtsBuildHelper getBuildHelper(IFolderBuildInfo iFolderBuildInfo) {
        CtsBuildHelper ctsBuildHelper = new CtsBuildHelper(iFolderBuildInfo.getRootDir());
        try {
            ctsBuildHelper.validateStructure();
        }
        catch (FileNotFoundException fileNotFoundException) {
            LogUtil.CLog.e((String)"Invalid CTS build %s", (Object[])new Object[]{iFolderBuildInfo.getRootDir()});
        }
        return ctsBuildHelper;
    }

    public void testLog(String string, LogDataType logDataType, InputStreamSource inputStreamSource) {
        try {
            File file = this.getLogFileSaver().saveAndZipLogData(string, logDataType, inputStreamSource.createInputStream());
            this.logResult(String.format("Saved log %s", file.getName()), new Object[0]);
        }
        catch (IOException iOException) {
            LogUtil.CLog.e((String)"Failed to write log for %s", (Object[])new Object[]{string});
        }
    }

    ILogFileSaver getLogFileSaver() {
        return new LogFileSaver(this.mLogDir);
    }

    public void testRunStarted(String string, int n) {
        if (this.mCurrentPkgResult != null && !string.equals(this.mCurrentPkgResult.getAppPackageName())) {
            this.logCompleteRun(this.mCurrentPkgResult);
        }
        this.mIsDeviceInfoRun = string.equals("android.tests.devicesetup");
        if (this.mIsDeviceInfoRun) {
            this.logResult("Collecting device info", new Object[0]);
        } else {
            if (this.mCurrentPkgResult == null || !string.equals(this.mCurrentPkgResult.getAppPackageName())) {
                this.logResult("-----------------------------------------", new Object[0]);
                this.logResult("Test package %s started", string);
                this.logResult("-----------------------------------------", new Object[0]);
            }
            this.mCurrentPkgResult = this.mResults.getOrCreatePackage(string);
        }
    }

    public void testStarted(TestIdentifier testIdentifier) {
        this.mCurrentPkgResult.insertTest(testIdentifier);
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
        this.mCurrentPkgResult.reportTestFailure(testIdentifier, CtsTestStatus.FAIL, string);
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
        this.mCurrentPkgResult.reportTestEnded(testIdentifier);
        Test test = this.mCurrentPkgResult.findTest(testIdentifier);
        String string = test.getStackTrace() == null ? "" : "\n" + test.getStackTrace();
        this.logResult("%s#%s %s %s", new Object[]{testIdentifier.getClassName(), testIdentifier.getTestName(), test.getResult(), string});
    }

    public void testRunEnded(long l, Map<String, String> map) {
        if (this.mIsDeviceInfoRun) {
            this.mResults.populateDeviceInfoMetrics(map);
        } else {
            this.mCurrentPkgResult.populateMetrics(map);
        }
    }

    public void invocationEnded(long l) {
        if (this.mCurrentPkgResult != null) {
            this.logCompleteRun(this.mCurrentPkgResult);
        }
        if (this.mReportDir == null || this.mStartTime == null) {
            LogUtil.CLog.w((String)"Unable to create XML report");
            return;
        }
        File file = this.getResultFile(this.mReportDir);
        this.createXmlResult(file, this.mStartTime, l);
        this.copyFormattingFiles(this.mReportDir);
        this.zipResults(this.mReportDir);
        try {
            ResultReporter resultReporter = new ResultReporter(this.mResultServer, file);
            resultReporter.reportResult();
        }
        catch (IOException iOException) {
            LogUtil.CLog.e((Throwable)iOException);
        }
    }

    private void logResult(String string, Object ... objectArray) {
        if (this.mQuietOutput) {
            LogUtil.CLog.i((String)string, (Object[])objectArray);
        } else {
            Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)this.mDeviceSerial, (String)String.format(string, objectArray));
        }
    }

    private void logCompleteRun(TestPackageResult testPackageResult) {
        if (testPackageResult.getAppPackageName().equals("android.tests.devicesetup")) {
            this.logResult("Device info collection complete", new Object[0]);
            return;
        }
        this.logResult("%s package complete: Passed %d, Failed %d, Not Executed %d", testPackageResult.getAppPackageName(), testPackageResult.countTests(CtsTestStatus.PASS), testPackageResult.countTests(CtsTestStatus.FAIL), testPackageResult.countTests(CtsTestStatus.NOT_EXECUTED));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXmlResult(File file, String string, long l) {
        String string2 = this.getTimestamp();
        OutputStream outputStream = null;
        try {
            outputStream = this.createOutputResultStream(file);
            KXmlSerializer kXmlSerializer = new KXmlSerializer();
            kXmlSerializer.setOutput(outputStream, "UTF-8");
            kXmlSerializer.startDocument("UTF-8", Boolean.valueOf(false));
            kXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            kXmlSerializer.processingInstruction("xml-stylesheet type=\"text/xsl\"  href=\"cts_result.xsl\"");
            this.serializeResultsDoc(kXmlSerializer, string, string2);
            kXmlSerializer.endDocument();
            String string3 = String.format("XML test result file generated at %s. Passed %d, Failed %d, Not Executed %d", this.mReportDir.getName(), this.mResults.countTests(CtsTestStatus.PASS), this.mResults.countTests(CtsTestStatus.FAIL), this.mResults.countTests(CtsTestStatus.NOT_EXECUTED));
            this.logResult(string3, new Object[0]);
            this.logResult("Time: %s", TimeUtil.formatElapsedTime(l));
        }
        catch (IOException iOException) {
            Log.e((String)LOG_TAG, (String)"Failed to generate report data");
        }
        finally {
            StreamUtil.closeStream((OutputStream)outputStream);
        }
    }

    private void serializeResultsDoc(KXmlSerializer kXmlSerializer, String string, String string2) throws IOException {
        kXmlSerializer.startTag(ns, RESULT_TAG);
        kXmlSerializer.attribute(ns, PLAN_ATTR, this.mPlanName);
        kXmlSerializer.attribute(ns, STARTTIME_ATTR, string);
        kXmlSerializer.attribute(ns, "endtime", string2);
        kXmlSerializer.attribute(ns, "version", CTS_RESULT_FILE_VERSION);
        this.mResults.serialize(kXmlSerializer);
    }

    private File getResultFile(File file) {
        return new File(file, TEST_RESULT_FILE_NAME);
    }

    OutputStream createOutputResultStream(File file) throws IOException {
        this.logResult("Created xml report file at file://%s", file.getAbsolutePath());
        return new FileOutputStream(file);
    }

    private void copyFormattingFiles(File file) {
        for (String string : CTS_RESULT_RESOURCES) {
            InputStream inputStream = this.getClass().getResourceAsStream(String.format("/report/%s", string));
            if (inputStream != null) {
                File file2 = new File(file, string);
                try {
                    FileUtil.writeToFile((InputStream)inputStream, (File)file2);
                }
                catch (IOException iOException) {
                    Log.w((String)LOG_TAG, (String)String.format("Failed to write %s to file", string));
                }
                continue;
            }
            Log.w((String)LOG_TAG, (String)String.format("Failed to load %s from jar", string));
        }
    }

    private void zipResults(File file) {
        try {
            File file2 = new File(file.getParent(), String.format("%s.zip", file.getName()));
            FileUtil.createZip((File)file, (File)file2);
        }
        catch (IOException iOException) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to create zip for %s", file.getName()));
        }
    }

    String getTimestamp() {
        return TimeUtil.getTimestamp();
    }

    public void testRunFailed(String string) {
    }

    public void testRunStopped(long l) {
    }

    public void invocationFailed(Throwable throwable) {
    }

    public TestSummary getSummary() {
        return null;
    }
}

