/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.tradefed.log.LogUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeviceInfoResult
extends AbstractXmlPullParser {
    static final String TAG = "DeviceInfo";
    private static final String ns = CtsXmlResultReporter.ns;
    static final String BUILD_TAG = "BuildInfo";
    private static final String PHONE_TAG = "PhoneSubInfo";
    private static final String SCREEN_TAG = "Screen";
    private static final String FEATURE_INFO_TAG = "FeatureInfo";
    private static final String FEATURE_TAG = "Feature";
    private static final String FEATURE_ATTR_DELIM = ":";
    private static final String FEATURE_DELIM = ";";
    private static final String OPENGL_TEXTURE_FORMATS_INFO_TAG = "OpenGLCompressedTextureFormatsInfo";
    private static final String OPENGL_TEXTURE_FORMAT_TAG = "TextureFormat";
    private static final String OPENGL_TEXTURE_FORMAT_DELIM = ";";
    private static final String SYSLIB_INFO_TAG = "SystemLibrariesInfo";
    private static final String SYSLIB_TAG = "Library";
    private static final String SYSLIB_DELIM = ";";
    private static final String PROCESS_INFO_TAG = "ProcessInfo";
    private static final String PROCESS_TAG = "Process";
    private static final String PROCESS_DELIM = ";";
    private static final String PROCESS_ATTR_DELIM = ":";
    private Map<String, String> mMetrics = new HashMap<String, String>();

    DeviceInfoResult() {
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        kXmlSerializer.startTag(ns, TAG);
        if (!this.mMetrics.isEmpty()) {
            HashMap<String, String> hashMap = new HashMap<String, String>(this.mMetrics);
            kXmlSerializer.startTag(ns, SCREEN_TAG);
            kXmlSerializer.attribute(ns, "resolution", this.getMetric(hashMap, "resolution"));
            kXmlSerializer.attribute(ns, "screen_density", this.getMetric(hashMap, "screen_density"));
            kXmlSerializer.attribute(ns, "screen_density_bucket", this.getMetric(hashMap, "screen_density_bucket"));
            kXmlSerializer.attribute(ns, "screen_size", this.getMetric(hashMap, "screen_size"));
            kXmlSerializer.endTag(ns, SCREEN_TAG);
            kXmlSerializer.startTag(ns, PHONE_TAG);
            kXmlSerializer.attribute(ns, "subscriberId", this.getMetric(hashMap, "subscriberId"));
            kXmlSerializer.endTag(ns, PHONE_TAG);
            String string = this.getMetric(hashMap, "features");
            String string2 = this.getMetric(hashMap, "processes");
            String string3 = this.getMetric(hashMap, "systemlibraries");
            String string4 = this.getMetric(hashMap, "openGlCompressedTextureFormats");
            kXmlSerializer.startTag(ns, BUILD_TAG);
            for (Map.Entry entry : hashMap.entrySet()) {
                kXmlSerializer.attribute(ns, (String)entry.getKey(), (String)entry.getValue());
            }
            kXmlSerializer.endTag(ns, BUILD_TAG);
            this.serializeFeatureInfo(kXmlSerializer, string);
            this.serializeProcessInfo(kXmlSerializer, string2);
            this.serializeSystemLibrariesInfo(kXmlSerializer, string3);
            this.serializeOpenGLCompressedTextureFormatsInfo(kXmlSerializer, string4);
        } else {
            LogUtil.CLog.d((String)"Could not find device info");
        }
        kXmlSerializer.endTag(ns, TAG);
    }

    private String getMetric(Map<String, String> map, String string) {
        String string2 = map.remove(string);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    private void serializeFeatureInfo(KXmlSerializer kXmlSerializer, String string) throws IOException {
        this.serialize(kXmlSerializer, FEATURE_INFO_TAG, FEATURE_TAG, ";", ":", string, "name", "type", "available");
    }

    private void serializeProcessInfo(KXmlSerializer kXmlSerializer, String string) throws IOException {
        this.serialize(kXmlSerializer, PROCESS_INFO_TAG, PROCESS_TAG, ";", ":", string, "name", "uid");
    }

    private void serializeOpenGLCompressedTextureFormatsInfo(KXmlSerializer kXmlSerializer, String string) throws IOException {
        this.serialize(kXmlSerializer, OPENGL_TEXTURE_FORMATS_INFO_TAG, OPENGL_TEXTURE_FORMAT_TAG, ";", null, string, "name");
    }

    private void serializeSystemLibrariesInfo(KXmlSerializer kXmlSerializer, String string) throws IOException {
        this.serialize(kXmlSerializer, SYSLIB_INFO_TAG, SYSLIB_TAG, ";", null, string, "name");
    }

    private void serialize(KXmlSerializer kXmlSerializer, String string, String string2, String string3, String string4, String string5, String ... stringArray) throws IOException {
        String[] stringArray2;
        kXmlSerializer.startTag(ns, string);
        if (string5 == null) {
            string5 = "";
        }
        for (String string6 : stringArray2 = string5.split(string3)) {
            String[] stringArray3;
            if (string6.isEmpty()) continue;
            if (string4 != null) {
                stringArray3 = string6.split(string4);
            } else {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = string6;
            }
            String[] stringArray5 = stringArray3;
            if (stringArray5.length != stringArray.length) continue;
            kXmlSerializer.startTag(ns, string2);
            for (int i = 0; i < stringArray.length; ++i) {
                kXmlSerializer.attribute(ns, stringArray[i], stringArray5[i]);
            }
            kXmlSerializer.endTag(ns, string2);
        }
        kXmlSerializer.endTag(ns, string);
    }

    @Override
    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(TAG)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", TAG, xmlPullParser.getName()));
        }
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            if (n == 2) {
                if (xmlPullParser.getName().equals(SCREEN_TAG) || xmlPullParser.getName().equals(PHONE_TAG) || xmlPullParser.getName().equals(BUILD_TAG)) {
                    this.addMetricsFromAttributes(xmlPullParser);
                } else if (xmlPullParser.getName().equals(FEATURE_INFO_TAG)) {
                    this.mMetrics.put("features", this.parseFeatures(xmlPullParser));
                } else if (xmlPullParser.getName().equals(PROCESS_INFO_TAG)) {
                    this.mMetrics.put("processes", this.parseProcess(xmlPullParser));
                } else if (xmlPullParser.getName().equals(SYSLIB_INFO_TAG)) {
                    this.mMetrics.put("systemlibraries", this.parseSystemLibraries(xmlPullParser));
                } else if (xmlPullParser.getName().equals(OPENGL_TEXTURE_FORMATS_INFO_TAG)) {
                    this.mMetrics.put("openGlCompressedTextureFormats", this.parseOpenGLCompressedTextureFormats(xmlPullParser));
                }
            } else if (n == 3 && xmlPullParser.getName().equals(TAG)) {
                return;
            }
            n = xmlPullParser.next();
        }
    }

    private String parseFeatures(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return this.parseTag(xmlPullParser, FEATURE_INFO_TAG, FEATURE_TAG, ";", ":", "name", "type", "available");
    }

    private String parseProcess(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return this.parseTag(xmlPullParser, PROCESS_INFO_TAG, PROCESS_TAG, ";", ":", "name", "uid");
    }

    private String parseOpenGLCompressedTextureFormats(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return this.parseTag(xmlPullParser, OPENGL_TEXTURE_FORMATS_INFO_TAG, OPENGL_TEXTURE_FORMAT_TAG, ";", null, "name");
    }

    private String parseSystemLibraries(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        return this.parseTag(xmlPullParser, SYSLIB_INFO_TAG, SYSLIB_TAG, ";", null, "name");
    }

    private String parseTag(XmlPullParser xmlPullParser, String string, String string2, String string3, String string4, String ... stringArray) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(string)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", string, xmlPullParser.getName()));
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = xmlPullParser.getEventType();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals(string2)) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuilder.append(this.getAttribute(xmlPullParser, stringArray[i]));
                    if (i + 1 >= stringArray.length) continue;
                    stringBuilder.append(string4);
                }
                stringBuilder.append(string3);
            } else if (n == 3 && xmlPullParser.getName().equals(string)) break;
            n = xmlPullParser.next();
        }
        return stringBuilder.toString();
    }

    private void addMetricsFromAttributes(XmlPullParser xmlPullParser) {
        int n = xmlPullParser.getAttributeCount();
        for (int i = 0; i < n; ++i) {
            this.mMetrics.put(xmlPullParser.getAttributeName(i), xmlPullParser.getAttributeValue(i));
        }
    }

    public void populateMetrics(Map<String, String> map) {
        if (this.mMetrics.isEmpty()) {
            this.mMetrics.putAll(map);
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        this.combineMetrics(hashMap, "subscriberId", "imsi", "imsi", "deviceID");
        this.checkMetrics(hashMap, "build_fingerprint", "build_model", "build_brand", "build_manufacturer", "build_board", "build_device", "buildName", "build_abi", "build_abi2", "screen_size");
    }

    private void combineMetrics(Map<String, String> map, String ... stringArray) {
        for (String string : stringArray) {
            String string2 = this.mMetrics.get(string);
            String string3 = map.remove(string);
            if (string3 != null) {
                if (string2 == null) {
                    this.mMetrics.put(string, string3);
                    continue;
                }
                if (string2.equals(string3)) continue;
                string3 = String.format("%s,%s", string2, string3);
                this.mMetrics.put(string, string3);
                continue;
            }
            LogUtil.CLog.d((String)"Missing metric %s", (Object[])new Object[]{string});
        }
    }

    private void checkMetrics(Map<String, String> map, String ... stringArray) {
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = this.mMetrics.get(entry.getKey());
            if (hashSet.contains(entry.getKey()) && string != null && !entry.getValue().equals(string)) {
                LogUtil.CLog.e((String)"Inconsistent info collected from devices. Current result has %s='%s', Received '%s'. Are you sharding or resuming a test run across different devices and/or builds?", (Object[])new Object[]{entry.getKey(), string, entry.getValue()});
                this.mMetrics.put(entry.getKey(), String.format("ERROR: Inconsistent results: %s, %s", entry.getValue(), string));
                continue;
            }
            this.mMetrics.put(entry.getKey(), entry.getValue());
        }
    }

    Map<String, String> getMetrics() {
        return this.mMetrics;
    }
}

