/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.cts.tradefed.result.TimeUtil;
import java.io.IOException;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class Test
extends AbstractXmlPullParser {
    static final String TAG = "Test";
    private static final String NAME_ATTR = "name";
    private static final String MESSAGE_ATTR = "message";
    private static final String ENDTIME_ATTR = "endtime";
    private static final String STARTTIME_ATTR = "starttime";
    private static final String RESULT_ATTR = "result";
    private static final String SCENE_TAG = "FailedScene";
    private static final String STACK_TAG = "StackTrace";
    private String mName;
    private CtsTestStatus mResult;
    private String mStartTime;
    private String mEndTime;
    private String mMessage;
    private String mStackTrace;

    public Test() {
    }

    public Test(String string) {
        this.mName = string;
        this.mResult = CtsTestStatus.NOT_EXECUTED;
        this.mStartTime = TimeUtil.getTimestamp();
        this.updateEndTime();
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public CtsTestStatus getResult() {
        return this.mResult;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public String getStartTime() {
        return this.mStartTime;
    }

    public String getEndTime() {
        return this.mEndTime;
    }

    public String getStackTrace() {
        return this.mStackTrace;
    }

    public void setStackTrace(String string) {
        this.mStackTrace = Test.sanitizeStackTrace(string);
        this.mMessage = Test.getFailureMessageFromStackTrace(this.mStackTrace);
    }

    public void updateEndTime() {
        this.mEndTime = TimeUtil.getTimestamp();
    }

    public void setResultStatus(CtsTestStatus ctsTestStatus) {
        this.mResult = ctsTestStatus;
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        kXmlSerializer.startTag(CtsXmlResultReporter.ns, TAG);
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, NAME_ATTR, this.getName());
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, RESULT_ATTR, this.mResult.getValue());
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, STARTTIME_ATTR, this.mStartTime);
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, ENDTIME_ATTR, this.mEndTime);
        if (this.mMessage != null) {
            kXmlSerializer.startTag(CtsXmlResultReporter.ns, SCENE_TAG);
            kXmlSerializer.attribute(CtsXmlResultReporter.ns, MESSAGE_ATTR, this.mMessage);
            if (this.mStackTrace != null) {
                kXmlSerializer.startTag(CtsXmlResultReporter.ns, STACK_TAG);
                kXmlSerializer.text(this.mStackTrace);
                kXmlSerializer.endTag(CtsXmlResultReporter.ns, STACK_TAG);
            }
            kXmlSerializer.endTag(CtsXmlResultReporter.ns, SCENE_TAG);
        }
        kXmlSerializer.endTag(CtsXmlResultReporter.ns, TAG);
    }

    private static String sanitizeStackTrace(String string) {
        if (string != null) {
            return string.replaceAll("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD]", "");
        }
        return null;
    }

    static String getFailureMessageFromStackTrace(String string) {
        int n;
        int n2 = string.indexOf(10);
        if (n2 != -1 && (n = string.indexOf(10, n2 + 1)) != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(TAG)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", TAG, xmlPullParser.getName()));
        }
        this.setName(this.getAttribute(xmlPullParser, NAME_ATTR));
        this.mResult = CtsTestStatus.getStatus(this.getAttribute(xmlPullParser, RESULT_ATTR));
        this.mStartTime = this.getAttribute(xmlPullParser, STARTTIME_ATTR);
        this.mEndTime = this.getAttribute(xmlPullParser, ENDTIME_ATTR);
        int n = xmlPullParser.next();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals(SCENE_TAG)) {
                this.mMessage = this.getAttribute(xmlPullParser, MESSAGE_ATTR);
            } else if (n == 2 && xmlPullParser.getName().equals(STACK_TAG)) {
                this.mStackTrace = xmlPullParser.nextText();
            } else if (n == 3 && xmlPullParser.getName().equals(TAG)) {
                return;
            }
            n = xmlPullParser.next();
        }
    }
}

