/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.cts.tradefed.result.Test;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.util.ArrayUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestCase
extends AbstractXmlPullParser {
    static final String TAG = "TestCase";
    private String mName;
    Map<String, Test> mChildTestMap = new LinkedHashMap<String, Test>();

    public TestCase(String string) {
        this.setName(string);
    }

    public TestCase() {
    }

    public void setName(String string) {
        this.mName = string;
    }

    public String getName() {
        return this.mName;
    }

    public Collection<Test> getTests() {
        return this.mChildTestMap.values();
    }

    public Test findTest(String string, boolean bl) {
        Test test = this.mChildTestMap.get(string);
        if (test == null && bl) {
            test = new Test(string);
            this.mChildTestMap.put(test.getName(), test);
        }
        return test;
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        kXmlSerializer.startTag(CtsXmlResultReporter.ns, TAG);
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, "name", this.getName());
        kXmlSerializer.attribute(CtsXmlResultReporter.ns, "priority", "");
        for (Test test : this.mChildTestMap.values()) {
            test.serialize(kXmlSerializer);
        }
        kXmlSerializer.endTag(CtsXmlResultReporter.ns, TAG);
    }

    @Override
    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(TAG)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", TAG, xmlPullParser.getName()));
        }
        this.setName(this.getAttribute(xmlPullParser, "name"));
        int n = xmlPullParser.next();
        while (n != 1) {
            if (n == 2 && xmlPullParser.getName().equals("Test")) {
                Test test = new Test();
                test.parse(xmlPullParser);
                this.mChildTestMap.put(test.getName(), test);
            } else if (n == 3 && xmlPullParser.getName().equals(TAG)) {
                return;
            }
            n = xmlPullParser.next();
        }
    }

    void addTestsWithStatus(Collection<TestIdentifier> collection, Deque<String> deque, CtsTestStatus ctsTestStatus) {
        if (this.getName() != null) {
            deque.addLast(this.getName());
        }
        String string = ArrayUtil.join((String)".", (Object[])new Object[]{deque});
        for (Test test : this.mChildTestMap.values()) {
            if (!ctsTestStatus.equals((Object)test.getResult())) continue;
            collection.add(new TestIdentifier(string, test.getName()));
        }
        if (this.getName() != null) {
            deque.removeLast();
        }
    }

    public int countTests(CtsTestStatus ctsTestStatus) {
        int n = 0;
        for (Test test : this.mChildTestMap.values()) {
            if (!test.getResult().equals((Object)ctsTestStatus)) continue;
            ++n;
        }
        return n;
    }
}

