/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.result;

import com.android.cts.tradefed.result.AbstractXmlPullParser;
import com.android.cts.tradefed.result.CtsTestStatus;
import com.android.cts.tradefed.result.CtsXmlResultReporter;
import com.android.cts.tradefed.result.Test;
import com.android.cts.tradefed.result.TestCase;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestSuite
extends AbstractXmlPullParser {
    static final String TAG = "TestSuite";
    private String mName;
    Map<String, TestSuite> mChildSuiteMap = new LinkedHashMap<String, TestSuite>();
    Map<String, TestCase> mChildTestCaseMap = new LinkedHashMap<String, TestCase>();

    public TestSuite(String string) {
        this.mName = string;
    }

    public TestSuite() {
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String string) {
        this.mName = string;
    }

    public Test findTest(List<String> list, String string, String string2, boolean bl) {
        if (list.size() <= 0) {
            TestCase testCase = this.getTestCase(string);
            return testCase.findTest(string2, bl);
        }
        String string3 = list.remove(0);
        TestSuite testSuite = this.getTestSuite(string3);
        return testSuite.findTest(list, string, string2, bl);
    }

    public Collection<TestSuite> getTestSuites() {
        return this.mChildSuiteMap.values();
    }

    public Collection<TestCase> getTestCases() {
        return this.mChildTestCaseMap.values();
    }

    private TestSuite getTestSuite(String string) {
        TestSuite testSuite = this.mChildSuiteMap.get(string);
        if (testSuite == null) {
            testSuite = new TestSuite(string);
            this.mChildSuiteMap.put(string, testSuite);
        }
        return testSuite;
    }

    private TestCase getTestCase(String string) {
        TestCase testCase = this.mChildTestCaseMap.get(string);
        if (testCase == null) {
            testCase = new TestCase(string);
            this.mChildTestCaseMap.put(string, testCase);
        }
        return testCase;
    }

    public void serialize(KXmlSerializer kXmlSerializer) throws IOException {
        if (this.mName != null) {
            kXmlSerializer.startTag(CtsXmlResultReporter.ns, TAG);
            kXmlSerializer.attribute(CtsXmlResultReporter.ns, "name", this.mName);
        }
        for (TestSuite abstractXmlPullParser : this.mChildSuiteMap.values()) {
            abstractXmlPullParser.serialize(kXmlSerializer);
        }
        for (TestCase testCase : this.mChildTestCaseMap.values()) {
            testCase.serialize(kXmlSerializer);
        }
        if (this.mName != null) {
            kXmlSerializer.endTag(CtsXmlResultReporter.ns, TAG);
        }
    }

    @Override
    void parse(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        if (!xmlPullParser.getName().equals(TAG)) {
            throw new XmlPullParserException(String.format("invalid XML: Expected %s tag but received %s", TAG, xmlPullParser.getName()));
        }
        this.setName(this.getAttribute(xmlPullParser, "name"));
        int n = xmlPullParser.next();
        while (n != 1) {
            AbstractXmlPullParser abstractXmlPullParser;
            if (n == 2 && xmlPullParser.getName().equals(TAG)) {
                abstractXmlPullParser = new TestSuite();
                ((TestSuite)abstractXmlPullParser).parse(xmlPullParser);
                this.insertSuite((TestSuite)abstractXmlPullParser);
            } else if (n == 2 && xmlPullParser.getName().equals("TestCase")) {
                abstractXmlPullParser = new TestCase();
                ((TestCase)abstractXmlPullParser).parse(xmlPullParser);
                this.insertTestCase((TestCase)abstractXmlPullParser);
            } else if (n == 3 && xmlPullParser.getName().equals(TAG)) {
                return;
            }
            n = xmlPullParser.next();
        }
    }

    public void insertTestCase(TestCase testCase) {
        this.mChildTestCaseMap.put(testCase.getName(), testCase);
    }

    public void insertSuite(TestSuite testSuite) {
        this.mChildSuiteMap.put(testSuite.getName(), testSuite);
    }

    void addTestsWithStatus(Collection<TestIdentifier> collection, Deque<String> deque, CtsTestStatus ctsTestStatus) {
        if (this.getName() != null) {
            deque.addLast(this.getName());
        }
        for (TestSuite abstractXmlPullParser : this.mChildSuiteMap.values()) {
            abstractXmlPullParser.addTestsWithStatus(collection, deque, ctsTestStatus);
        }
        for (TestCase testCase : this.mChildTestCaseMap.values()) {
            testCase.addTestsWithStatus(collection, deque, ctsTestStatus);
        }
        if (this.getName() != null) {
            deque.removeLast();
        }
    }

    public int countTests(CtsTestStatus ctsTestStatus) {
        int n = 0;
        for (TestSuite abstractXmlPullParser : this.mChildSuiteMap.values()) {
            n += abstractXmlPullParser.countTests(ctsTestStatus);
        }
        for (TestCase testCase : this.mChildTestCaseMap.values()) {
            n += testCase.countTests(ctsTestStatus);
        }
        return n;
    }
}

