/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.testtype.AccessibilityTestRunner;
import com.android.cts.tradefed.testtype.InstrumentationApkTest;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import junit.framework.TestCase;

public class AccessibilityServiceTestRunner
extends InstrumentationApkTest {
    private static final String DELEGATING_ACCESSIBLITY_SERVICE_PACKAGE_NAME = "android.accessibilityservice.delegate";
    private static final String DELEGATING_ACCESSIBLITY_SERVICE_NAME = "android.accessibilityservice.delegate.DelegatingAccessibilityService";
    private static final String DELEGATING_ACCESSIBLITY_SERVICE_APK = "CtsDelegatingAccessibilityService.apk";
    private CtsBuildHelper mCtsBuild;

    public void setBuild(IBuildInfo iBuildInfo) {
        super.setBuild(iBuildInfo);
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        this.beforeTest();
        super.run(iTestInvocationListener);
        this.afterTest();
    }

    private void beforeTest() throws DeviceNotAvailableException {
        this.installApkAndAssert(DELEGATING_ACCESSIBLITY_SERVICE_APK);
        this.enableAccessibilityAndDelegatingService();
    }

    private void afterTest() throws DeviceNotAvailableException {
        AccessibilityTestRunner.disableAccessibilityAndServicesAndTouchExploration(this.getDevice());
        this.uninstallAndAssert(DELEGATING_ACCESSIBLITY_SERVICE_PACKAGE_NAME);
    }

    private void installApkAndAssert(String string) throws DeviceNotAvailableException {
        File file = FileUtil.getFileForPath((File)this.mCtsBuild.getTestCasesDir(), (String[])new String[]{string});
        String string2 = this.getDevice().installPackage(file, true, new String[0]);
        TestCase.assertNull((String)("Error installing: " + string), (Object)string2);
    }

    private void uninstallAndAssert(String string) throws DeviceNotAvailableException {
        String string2 = this.getDevice().uninstallPackage(string);
        TestCase.assertNull((String)("Error uninstalling: " + string), (Object)string2);
    }

    private void enableAccessibilityAndDelegatingService() throws DeviceNotAvailableException {
        String string = "android.accessibilityservice.delegate/android.accessibilityservice.delegate.DelegatingAccessibilityService";
        AccessibilityTestRunner.enableAccessibilityAndServicesAndTouchExploration(this.getDevice(), string);
    }
}

