/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.targetprep.SettingsToggler;
import com.android.cts.tradefed.testtype.InstrumentationApkTest;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import junit.framework.TestCase;

public class AccessibilityTestRunner
extends InstrumentationApkTest {
    private static final String SOME_ACCESSIBLITY_SERVICES_PACKAGE_NAME = "android.view.accessibility.services";
    private static final String SPEAKING_ACCESSIBLITY_SERVICE_NAME = "android.view.accessibility.services.SpeakingAccessibilityService";
    private static final String VIBRATING_ACCESSIBLITY_SERVICE_NAME = "android.view.accessibility.services.VibratingAccessibilityService";
    private static final String SOME_ACCESSIBLITY_SERVICES_APK = "CtsSomeAccessibilityServices.apk";
    private CtsBuildHelper mCtsBuild;

    public void setBuild(IBuildInfo iBuildInfo) {
        super.setBuild(iBuildInfo);
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        this.beforeTest();
        super.run(iTestInvocationListener);
        this.afterTest();
    }

    private void beforeTest() throws DeviceNotAvailableException {
        this.installApkAndAssert(SOME_ACCESSIBLITY_SERVICES_APK);
        this.enableAccessibilityAndServicesAndTouchExploration();
    }

    private void afterTest() throws DeviceNotAvailableException {
        AccessibilityTestRunner.disableAccessibilityAndServicesAndTouchExploration(this.getDevice());
        this.uninstallAndAssert(SOME_ACCESSIBLITY_SERVICES_PACKAGE_NAME);
    }

    private void installApkAndAssert(String string) throws DeviceNotAvailableException {
        File file = FileUtil.getFileForPath((File)this.mCtsBuild.getTestCasesDir(), (String[])new String[]{string});
        String string2 = this.getDevice().installPackage(file, true, new String[0]);
        TestCase.assertNull((String)("Error installing: " + string), (Object)string2);
    }

    private void uninstallAndAssert(String string) throws DeviceNotAvailableException {
        String string2 = this.getDevice().uninstallPackage(string);
        TestCase.assertNull((String)("Error uninstalling: " + string), (Object)string2);
    }

    private void enableAccessibilityAndServicesAndTouchExploration() throws DeviceNotAvailableException {
        String string = "android.view.accessibility.services/android.view.accessibility.services.SpeakingAccessibilityService:android.view.accessibility.services/android.view.accessibility.services.VibratingAccessibilityService";
        AccessibilityTestRunner.enableAccessibilityAndServicesAndTouchExploration(this.getDevice(), string);
    }

    static void enableAccessibilityAndServicesAndTouchExploration(ITestDevice iTestDevice, String string) throws DeviceNotAvailableException {
        SettingsToggler.setSecureString(iTestDevice, "enabled_accessibility_services", string);
        SettingsToggler.setSecureInt(iTestDevice, "accessibility_enabled", 1);
        SettingsToggler.setSecureInt(iTestDevice, "touch_exploration_enabled", 1);
    }

    static void disableAccessibilityAndServicesAndTouchExploration(ITestDevice iTestDevice) throws DeviceNotAvailableException {
        SettingsToggler.updateSecureString(iTestDevice, "enabled_accessibility_services", "");
        SettingsToggler.updateSecureInt(iTestDevice, "accessibility_enabled", 0);
        SettingsToggler.updateSecureInt(iTestDevice, "touch_exploration_enabled", 0);
    }
}

