/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.testtype.GeeTestResultParser;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import java.io.File;

public class GeeTest
implements IBuildReceiver,
IDeviceTest,
IRemoteTest {
    private static final String NATIVE_TESTS_DIRECTORY = "/data/local/tmp/cts-native-tests";
    private int mMaxTestTimeMs = 60000;
    private CtsBuildHelper mCtsBuild;
    private ITestDevice mDevice;
    private final String mPackageName;
    private final String mExeName;

    public GeeTest(String string, String string2) {
        this.mPackageName = string;
        this.mExeName = string2;
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (this.installTest()) {
            this.runTest((ITestRunListener)iTestInvocationListener);
        } else {
            LogUtil.CLog.e((String)"Failed to install native tests");
        }
    }

    private boolean installTest() throws DeviceNotAvailableException {
        if (!this.createRemoteDir(NATIVE_TESTS_DIRECTORY)) {
            LogUtil.CLog.e((String)"Could not create directory for native tests: /data/local/tmp/cts-native-tests");
            return false;
        }
        File file = new File(this.mCtsBuild.getTestCasesDir(), this.mExeName);
        if (!file.exists()) {
            LogUtil.CLog.e((String)("Native test not found: " + file));
            return false;
        }
        File file2 = new File(NATIVE_TESTS_DIRECTORY, this.mExeName);
        if (!this.mDevice.pushFile(file, file2.toString())) {
            LogUtil.CLog.e((String)"Failed to push native test to device");
            return false;
        }
        return true;
    }

    private boolean createRemoteDir(String string) throws DeviceNotAvailableException {
        if (this.mDevice.doesFileExist(string)) {
            return true;
        }
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null && !this.createRemoteDir(string2)) {
            return false;
        }
        this.mDevice.executeShellCommand(String.format("mkdir %s", string));
        return this.mDevice.doesFileExist(string);
    }

    void runTest(ITestRunListener iTestRunListener) throws DeviceNotAvailableException {
        GeeTestResultParser geeTestResultParser = new GeeTestResultParser(this.mPackageName, iTestRunListener);
        geeTestResultParser.setFakePackagePrefix(this.mPackageName + ".");
        String string = NATIVE_TESTS_DIRECTORY + File.separator + this.mExeName;
        String string2 = "";
        LogUtil.CLog.v((String)"Running gtest %s %s on %s", (Object[])new Object[]{string, string2, this.mDevice.getSerialNumber()});
        LogUtil.CLog.v((String)"%s", (Object[])new Object[]{this.mDevice.executeShellCommand(String.format("chmod 755 %s", string))});
        try {
            this.mDevice.executeShellCommand(String.format("%s %s", string, string2), (IShellOutputReceiver)geeTestResultParser, this.mMaxTestTimeMs, 0);
        }
        catch (DeviceNotAvailableException deviceNotAvailableException) {
            geeTestResultParser.flush();
            throw deviceNotAvailableException;
        }
        catch (RuntimeException runtimeException) {
            geeTestResultParser.flush();
            throw runtimeException;
        }
    }

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }
}

