/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeeTestResultParser
extends MultiLineReceiver {
    private static final String LOG_TAG = "GTestResultParser";
    private TestResult mCurrentTestResult = null;
    private int mNumTestsRun = 0;
    private int mNumTestsExpected = 0;
    private long mTotalRunTime = 0L;
    private boolean mTestInProgress = false;
    private boolean mTestRunInProgress = false;
    private final String mTestRunName;
    private final Collection<ITestRunListener> mTestListeners;
    private String mFakePackagePrefix = "";
    private boolean mTestRunStartReported = false;
    private boolean mIsCancelled = false;
    private String mCoverageTarget = null;

    public GeeTestResultParser(String string, Collection<ITestRunListener> collection) {
        this.mTestRunName = string;
        this.mTestListeners = new ArrayList<ITestRunListener>(collection);
    }

    public GeeTestResultParser(String string, ITestRunListener iTestRunListener) {
        this.mTestRunName = string;
        this.mTestListeners = new ArrayList<ITestRunListener>(1);
        this.mTestListeners.add(iTestRunListener);
    }

    public void setFakePackagePrefix(String string) {
        this.mFakePackagePrefix = string;
    }

    private TestResult getCurrentTestResult() {
        if (this.mCurrentTestResult == null) {
            this.mCurrentTestResult = new TestResult();
        }
        return this.mCurrentTestResult;
    }

    private void clearCurrentTestResult() {
        this.mCurrentTestResult = null;
    }

    public void processNewLines(String[] stringArray) {
        for (String string : stringArray) {
            this.parse(string);
        }
    }

    private void parse(String string) {
        String string2 = null;
        if (this.mTestRunInProgress || string.startsWith("[==========]")) {
            if (string.startsWith("[ RUN      ]")) {
                string2 = string.substring("[ RUN      ]".length()).trim();
                this.processTestStartedTag(string2);
            } else if (string.startsWith("[       OK ]")) {
                string2 = string.substring("[       OK ]".length()).trim();
                this.processOKTag(string2);
                this.clearCurrentTestResult();
            } else if (string.startsWith("[  FAILED  ]")) {
                string2 = string.substring("[  FAILED  ]".length()).trim();
                this.processFailedTag(string2);
                this.clearCurrentTestResult();
            } else if (string.startsWith("[==========] Running")) {
                string2 = string.substring("[==========]".length()).trim();
                this.processRunStartedTag(string2);
            } else if (string.startsWith("[==========]")) {
                string2 = string.substring("[==========]".length()).trim();
                this.processRunCompletedTag(string2);
            } else if (this.testInProgress()) {
                this.appendTestOutputLine(string);
            }
        }
    }

    public boolean isCancelled() {
        return this.mIsCancelled;
    }

    public void cancel() {
        this.mIsCancelled = true;
    }

    private boolean testInProgress() {
        return this.mTestInProgress;
    }

    private void setTestStarted() {
        this.mTestInProgress = true;
    }

    private void setTestEnded() {
        this.mTestInProgress = false;
    }

    private void reportTestRunStarted() {
        if (!this.mTestRunStartReported) {
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                iTestRunListener.testRunStarted(this.mTestRunName, this.mNumTestsExpected);
            }
            this.mTestRunStartReported = true;
        }
    }

    private void reportTestRunEnded() {
        for (ITestRunListener iTestRunListener : this.mTestListeners) {
            iTestRunListener.testRunEnded(this.mTotalRunTime, this.getRunMetrics());
        }
        this.mTestRunStartReported = false;
    }

    private Map<String, String> getRunMetrics() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.mCoverageTarget != null) {
            hashMap.put("coverage_target", this.mCoverageTarget);
        }
        return hashMap;
    }

    private ParsedTestInfo parseTestIdentifier(String string) {
        String[] stringArray;
        ParsedTestInfo parsedTestInfo = new ParsedTestInfo("UNKNOWN_CLASS", "UNKNOWN_TEST", null);
        Pattern pattern = Pattern.compile(".*(\\((\\d+) ms\\))");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            stringArray = matcher.group(2);
            String string2 = matcher.group(1);
            string = string.substring(0, string.lastIndexOf(string2)).trim();
            parsedTestInfo.mTestRunTime = stringArray;
        }
        if ((stringArray = string.split("\\.")).length < 2) {
            Log.e((String)LOG_TAG, (String)("Could not detect the test class and test name, received: " + string));
        } else {
            parsedTestInfo.mTestClassName = stringArray[0];
            parsedTestInfo.mTestName = stringArray[1];
        }
        return parsedTestInfo;
    }

    private void processRunStartedTag(String string) {
        Pattern pattern = Pattern.compile("Running (\\d+) test[s]? from .*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            try {
                this.mNumTestsExpected = Integer.parseInt(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)LOG_TAG, (String)("Unable to determine number of tests expected, received: " + matcher.group(1)));
            }
        }
        if (this.mNumTestsExpected > 0) {
            this.reportTestRunStarted();
            this.mNumTestsRun = 0;
            this.mTestRunInProgress = true;
        }
    }

    private void processRunCompletedTag(String string) {
        Pattern pattern = Pattern.compile(".*\\((\\d+) ms total\\)");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            try {
                this.mTotalRunTime = Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)LOG_TAG, (String)("Unable to determine the total running time, received: " + matcher.group(1)));
            }
        }
        this.reportTestRunEnded();
        this.mTestRunInProgress = false;
    }

    private void processTestStartedTag(String string) {
        ParsedTestInfo parsedTestInfo = this.parseTestIdentifier(string);
        TestResult testResult = this.getCurrentTestResult();
        testResult.mTestClass = parsedTestInfo.mTestClassName;
        testResult.mTestName = parsedTestInfo.mTestName;
        TestIdentifier testIdentifier = new TestIdentifier(this.mFakePackagePrefix + testResult.mTestClass, testResult.mTestName);
        for (ITestRunListener iTestRunListener : this.mTestListeners) {
            iTestRunListener.testStarted(testIdentifier);
        }
        this.setTestStarted();
    }

    private void doTestEnded(String string, boolean bl) {
        ParsedTestInfo parsedTestInfo = this.parseTestIdentifier(string);
        TestResult testResult = this.getCurrentTestResult();
        TestIdentifier testIdentifier = new TestIdentifier(this.mFakePackagePrefix + testResult.mTestClass, testResult.mTestName);
        if (!this.testInProgress()) {
            Log.e((String)LOG_TAG, (String)("Test currently not in progress when trying to end test: " + string));
            return;
        }
        if (parsedTestInfo.mTestRunTime != null) {
            try {
                testResult.mRunTime = new Long(parsedTestInfo.mTestRunTime);
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)LOG_TAG, (String)("Test run time value is invalid, received: " + parsedTestInfo.mTestRunTime));
            }
        }
        boolean bl2 = false;
        if (!testResult.isComplete()) {
            Log.e((String)LOG_TAG, (String)"No test/class name is currently recorded as running!");
        } else {
            if (testResult.mTestClass.compareTo(parsedTestInfo.mTestClassName) != 0) {
                Log.e((String)LOG_TAG, (String)("Name for current test class does not match class we started with, expected: " + testResult.mTestClass + " but got: " + parsedTestInfo.mTestClassName));
                bl2 = true;
            }
            if (testResult.mTestName.compareTo(parsedTestInfo.mTestName) != 0) {
                Log.e((String)LOG_TAG, (String)("Name for current test does not match test we started with,expected: " + testResult.mTestName + " bug got: " + parsedTestInfo.mTestName));
                bl2 = true;
            }
        }
        if (bl2) {
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                iTestRunListener.testFailed(ITestRunListener.TestFailure.ERROR, testIdentifier, this.mCurrentTestResult.getTrace());
            }
        } else if (!bl) {
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                iTestRunListener.testFailed(ITestRunListener.TestFailure.FAILURE, testIdentifier, this.mCurrentTestResult.getTrace());
            }
        }
        Iterator<ITestRunListener> iterator = Collections.emptyMap();
        for (ITestRunListener iTestRunListener : this.mTestListeners) {
            iTestRunListener.testEnded(testIdentifier, iterator);
        }
        this.setTestEnded();
        ++this.mNumTestsRun;
    }

    private void processOKTag(String string) {
        this.doTestEnded(string, true);
    }

    private void processFailedTag(String string) {
        this.doTestEnded(string, false);
    }

    private void appendTestOutputLine(String string) {
        TestResult testResult = this.getCurrentTestResult();
        if (testResult.mStackTrace == null) {
            testResult.mStackTrace = new StringBuilder();
        } else {
            testResult.mStackTrace.append("\r\n");
        }
        testResult.mStackTrace.append(string);
    }

    private void handleTestRunFailed(String string) {
        string = string == null ? "Unknown error" : string;
        Log.i((String)LOG_TAG, (String)String.format("Test run failed: %s", string));
        String string2 = "";
        if (this.mCurrentTestResult != null && this.mCurrentTestResult.isComplete()) {
            TestIdentifier testIdentifier = new TestIdentifier(this.mCurrentTestResult.mTestClass, this.mCurrentTestResult.mTestName);
            Object object = Collections.emptyMap();
            if (this.mCurrentTestResult.hasStackTrace()) {
                string2 = this.mCurrentTestResult.getTrace();
            }
            for (ITestRunListener iTestRunListener : this.mTestListeners) {
                iTestRunListener.testFailed(ITestRunListener.TestFailure.ERROR, testIdentifier, "No test results.\r\n" + string2);
                iTestRunListener.testEnded(testIdentifier, (Map)object);
            }
            this.clearCurrentTestResult();
        }
        for (Object object : this.mTestListeners) {
            object.testRunFailed(string);
            object.testRunEnded(this.mTotalRunTime, this.getRunMetrics());
        }
    }

    public void done() {
        super.done();
        if (this.mNumTestsExpected > this.mNumTestsRun) {
            this.handleTestRunFailed(String.format("Test run incomplete. Expected %d tests, received %d", this.mNumTestsExpected, this.mNumTestsRun));
        } else if (this.mTestRunInProgress) {
            this.handleTestRunFailed("No test results");
        }
    }

    public void setCoverageTarget(String string) {
        this.mCoverageTarget = string;
    }

    private static class Prefixes {
        private static final String INFORMATIONAL_MARKER = "[----------]";
        private static final String START_TEST_RUN_MARKER = "[==========] Running";
        private static final String TEST_RUN_MARKER = "[==========]";
        private static final String START_TEST_MARKER = "[ RUN      ]";
        private static final String OK_TEST_MARKER = "[       OK ]";
        private static final String FAILED_TEST_MARKER = "[  FAILED  ]";

        private Prefixes() {
        }
    }

    private static class ParsedTestInfo {
        String mTestName = null;
        String mTestClassName = null;
        String mTestRunTime = null;

        public ParsedTestInfo(String string, String string2, String string3) {
            this.mTestName = string;
            this.mTestClassName = string2;
            this.mTestRunTime = string3;
        }
    }

    private static class TestResult {
        private String mTestName = null;
        private String mTestClass = null;
        private StringBuilder mStackTrace = null;
        private Long mRunTime = null;

        private TestResult() {
        }

        boolean isComplete() {
            return this.mTestName != null && this.mTestClass != null;
        }

        boolean hasStackTrace() {
            return this.mStackTrace != null;
        }

        String getTrace() {
            if (this.hasStackTrace()) {
                return this.mStackTrace.toString();
            }
            Log.e((String)GeeTestResultParser.LOG_TAG, (String)"Could not find stack trace for failed test");
            return new Throwable("Unknown failure").toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.mTestClass != null) {
                stringBuilder.append(this.mTestClass);
                stringBuilder.append('#');
            }
            if (this.mTestName != null) {
                stringBuilder.append(this.mTestName);
            }
            if (stringBuilder.length() > 0) {
                return stringBuilder.toString();
            }
            return "unknown result";
        }
    }
}

