/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.testtype.TestTimeoutException;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.hosttest.DeviceTest;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.DeviceTestResult;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.JUnitRunUtil;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarHostTest
implements IDeviceTest,
IRemoteTest,
IBuildReceiver,
Test {
    private static final String LOG_TAG = "JarHostTest";
    private ITestDevice mDevice;
    private String mJarFileName;
    private Collection<TestIdentifier> mTests;
    private long mTimeoutMs = 600000L;
    private String mRunName;
    private CtsBuildHelper mCtsBuild = null;
    private IBuildInfo mBuildInfo = null;
    private ClassLoader mClassLoader;

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mBuildInfo = iBuildInfo;
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    void setBuildHelper(CtsBuildHelper ctsBuildHelper) {
        this.mCtsBuild = ctsBuildHelper;
    }

    CtsBuildHelper getBuildHelper() {
        return this.mCtsBuild;
    }

    void setJarFileName(String string) {
        this.mJarFileName = string;
    }

    String getJarFileName() {
        return this.mJarFileName;
    }

    void setTests(Collection<TestIdentifier> collection) {
        this.mTests = collection;
    }

    Collection<TestIdentifier> getTests() {
        return this.mTests;
    }

    void setTimeout(long l) {
        this.mTimeoutMs = l;
    }

    void setRunName(String string) {
        this.mRunName = string;
    }

    public ITestDevice getDevice() {
        return this.mDevice;
    }

    public void setDevice(ITestDevice iTestDevice) {
        this.mDevice = iTestDevice;
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        this.checkFields();
        Log.i((String)LOG_TAG, (String)String.format("Running %s test package from jar, contains %d tests.", this.mRunName, this.mTests.size()));
        JUnitRunUtil.runTest((ITestInvocationListener)iTestInvocationListener, (Test)this, (String)this.mRunName);
    }

    public void run(TestResult testResult) {
        for (TestIdentifier testIdentifier : this.mTests) {
            Test test = this.loadTest(testIdentifier.getClassName(), testIdentifier.getTestName());
            if (test == null) continue;
            this.runTest(testIdentifier, test, testResult);
        }
    }

    private void runTest(TestIdentifier testIdentifier, Test test, TestResult testResult) {
        Object object;
        if (test instanceof IDeviceTest) {
            ((IDeviceTest)test).setDevice(this.getDevice());
        } else if (test instanceof DeviceTest) {
            object = (DeviceTest)test;
            object.setDevice(this.getDevice().getIDevice());
            object.setTestAppPath(this.mCtsBuild.getTestCasesDir().getAbsolutePath());
        }
        if (test instanceof IBuildReceiver) {
            ((IBuildReceiver)test).setBuild(this.mBuildInfo);
        }
        object = new TestRunnable(test, testResult);
        CommandStatus commandStatus = RunUtil.getDefault().runTimed(this.mTimeoutMs, (IRunUtil.IRunnableResult)object, true);
        if (commandStatus.equals((Object)CommandStatus.TIMED_OUT)) {
            testResult.addError(test, (Throwable)new TestTimeoutException());
            testResult.endTest(test);
        }
        if (((TestRunnable)object).getException() != null) {
            throw ((TestRunnable)object).getException();
        }
    }

    private Test loadTest(String string, String string2) {
        try {
            Class<?> clazz = this.loadClass(string);
            if (clazz == null) {
                return null;
            }
            if (TestCase.class.isAssignableFrom(clazz)) {
                TestCase testCase = (TestCase)clazz.newInstance();
                testCase.setName(string2);
                return testCase;
            }
            if (Test.class.isAssignableFrom(clazz)) {
                Test test = (Test)clazz.newInstance();
                return test;
            }
            Log.e((String)LOG_TAG, (String)String.format("Class '%s' from jar '%s' is not a Test", string, this.mJarFileName));
        }
        catch (IllegalAccessException illegalAccessException) {
            this.reportLoadError(this.mJarFileName, string, illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            this.reportLoadError(this.mJarFileName, string, instantiationException);
        }
        return null;
    }

    private Class<?> loadClass(String string) {
        try {
            if (this.mClassLoader == null) {
                File file = this.mCtsBuild.getTestApp(this.mJarFileName);
                URL[] uRLArray = new URL[]{file.getCanonicalFile().toURI().toURL()};
                this.mClassLoader = new URLClassLoader(uRLArray);
            }
            return this.mClassLoader.loadClass(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.reportLoadError(this.mJarFileName, string, fileNotFoundException);
        }
        catch (MalformedURLException malformedURLException) {
            this.reportLoadError(this.mJarFileName, string, malformedURLException);
        }
        catch (IOException iOException) {
            this.reportLoadError(this.mJarFileName, string, iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.reportLoadError(this.mJarFileName, string, classNotFoundException);
        }
        return null;
    }

    Class<?> loadClass(String string, URL[] uRLArray) throws ClassNotFoundException {
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
        Class<?> clazz = uRLClassLoader.loadClass(string);
        return clazz;
    }

    private void reportLoadError(String string, String string2, Exception exception) {
        Log.e((String)LOG_TAG, (String)String.format("Failed to load test class '%s' from jar '%s'", string2, string));
        Log.e((String)LOG_TAG, (Throwable)exception);
    }

    protected void checkFields() {
        if (this.mRunName == null) {
            throw new IllegalArgumentException("run name has not been set");
        }
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        if (this.mJarFileName == null) {
            throw new IllegalArgumentException("jar file name has not been set");
        }
        if (this.mTests == null) {
            throw new IllegalArgumentException("tests has not been set");
        }
        if (this.mCtsBuild == null) {
            throw new IllegalArgumentException("build has not been set");
        }
        try {
            this.mCtsBuild.getTestApp(this.mJarFileName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException(String.format("Could not find jar %s in CTS build %s", this.mJarFileName, this.mCtsBuild.getRootDir().getAbsolutePath()));
        }
    }

    public int countTestCases() {
        return this.mTests.size();
    }

    private static class TestRunnable
    implements IRunUtil.IRunnableResult {
        private final Test mJunitTest;
        private DeviceTestResult.RuntimeDeviceNotAvailableException mException = null;
        private TestResult mJunitResult;

        TestRunnable(Test test, TestResult testResult) {
            this.mJunitTest = test;
            this.mJunitResult = testResult;
        }

        public boolean run() throws Exception {
            try {
                this.mJunitTest.run(this.mJunitResult);
            }
            catch (DeviceTestResult.RuntimeDeviceNotAvailableException runtimeDeviceNotAvailableException) {
                this.mException = runtimeDeviceNotAvailableException;
            }
            return true;
        }

        public DeviceTestResult.RuntimeDeviceNotAvailableException getException() {
            return this.mException;
        }

        public void cancel() {
        }
    }
}

