/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.CtsTest;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ResultForwarder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultFilter
extends ResultForwarder {
    private final Map<String, Collection<TestIdentifier>> mKnownTestsMap = new HashMap<String, Collection<TestIdentifier>>();
    private final Map<String, Collection<TestIdentifier>> mRemainingTestsMap = new LinkedHashMap<String, Collection<TestIdentifier>>();
    private String mCurrentTestRun = null;

    ResultFilter(ITestInvocationListener iTestInvocationListener, List<CtsTest.TestPackage> list) {
        super(new ITestInvocationListener[]{iTestInvocationListener});
        for (CtsTest.TestPackage testPackage : list) {
            this.mKnownTestsMap.put(testPackage.getTestRunName(), new HashSet<TestIdentifier>(testPackage.getKnownTests()));
            this.mRemainingTestsMap.put(testPackage.getTestRunName(), new LinkedHashSet<TestIdentifier>(testPackage.getKnownTests()));
        }
    }

    public void testRunStarted(String string, int n) {
        super.testRunStarted(string, n);
        this.mCurrentTestRun = string;
    }

    public void testStarted(TestIdentifier testIdentifier) {
        if (this.isKnownTest(testIdentifier)) {
            super.testStarted(testIdentifier);
        } else {
            LogUtil.CLog.d((String)"Skipping reporting unknown test %s", (Object[])new Object[]{testIdentifier});
        }
    }

    public void testFailed(ITestRunListener.TestFailure testFailure, TestIdentifier testIdentifier, String string) {
        if (this.isKnownTest(testIdentifier)) {
            super.testFailed(testFailure, testIdentifier, string);
        }
    }

    public void testEnded(TestIdentifier testIdentifier, Map<String, String> map) {
        if (this.isKnownTest(testIdentifier)) {
            super.testEnded(testIdentifier, map);
            this.removeExecutedTest(testIdentifier);
        }
    }

    private boolean isKnownTest(TestIdentifier testIdentifier) {
        if (this.mCurrentTestRun != null && this.mKnownTestsMap.containsKey(this.mCurrentTestRun)) {
            return this.mKnownTestsMap.get(this.mCurrentTestRun).contains(testIdentifier);
        }
        return false;
    }

    private void removeExecutedTest(TestIdentifier testIdentifier) {
        if (this.mCurrentTestRun != null && this.mRemainingTestsMap.containsKey(this.mCurrentTestRun)) {
            this.mRemainingTestsMap.get(this.mCurrentTestRun).remove(testIdentifier);
        }
    }

    public void reportUnexecutedTests() {
        for (Map.Entry<String, Collection<TestIdentifier>> entry : this.mRemainingTestsMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            super.testRunStarted(entry.getKey(), entry.getValue().size());
            for (TestIdentifier testIdentifier : entry.getValue()) {
                super.testStarted(testIdentifier);
            }
            super.testRunEnded(0L, new HashMap());
        }
    }
}

