/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.AccessibilityServiceTestRunner;
import com.android.cts.tradefed.testtype.AccessibilityTestRunner;
import com.android.cts.tradefed.testtype.GeeTest;
import com.android.cts.tradefed.testtype.ITestPackageDef;
import com.android.cts.tradefed.testtype.InstrumentationApkTest;
import com.android.cts.tradefed.testtype.JarHostTest;
import com.android.cts.tradefed.testtype.TestFilter;
import com.android.cts.tradefed.testtype.UiAutomatorJarTest;
import com.android.cts.tradefed.testtype.VMHostTest;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import com.android.tradefed.util.StreamUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestPackageDef
implements ITestPackageDef {
    public static final String HOST_SIDE_ONLY_TEST = "hostSideOnly";
    public static final String NATIVE_TEST = "native";
    public static final String VM_HOST_TEST = "vmHostTest";
    public static final String ACCESSIBILITY_TEST = "com.android.cts.tradefed.testtype.AccessibilityTestRunner";
    public static final String ACCESSIBILITYSERVICE_TEST = "com.android.cts.tradefed.testtype.AccessibilityServiceTestRunner";
    public static final String UIAUTOMATOR_TEST = "uiAutomator";
    private static final String SIGNATURE_TEST_METHOD = "testSignature";
    private static final String SIGNATURE_TEST_CLASS = "android.tests.sigtest.SimpleSignatureTest";
    private String mUri = null;
    private String mAppNameSpace = null;
    private String mName = null;
    private String mRunner = null;
    private boolean mIsVMHostTest = false;
    private String mTestType = null;
    private String mJarPath = null;
    private boolean mIsSignatureTest = false;
    private String mTestPackageName = null;
    private String mDigest = null;
    private Collection<TestIdentifier> mTests = new LinkedHashSet<TestIdentifier>();
    private Collection<String> mTestClasses = new LinkedHashSet<String>();
    private String mClassName;
    private String mMethodName;
    private TestFilter mExcludedTestFilter = new TestFilter();
    private String mTargetBinaryName;
    private String mTargetNameSpace;

    TestPackageDef() {
    }

    void setUri(String string) {
        this.mUri = string;
    }

    @Override
    public String getUri() {
        return this.mUri;
    }

    void setAppNameSpace(String string) {
        this.mAppNameSpace = string;
    }

    String getAppNameSpace() {
        return this.mAppNameSpace;
    }

    void setName(String string) {
        this.mName = string;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    void setRunner(String string) {
        this.mRunner = string;
    }

    String getRunner() {
        return this.mRunner;
    }

    void setTestType(String string) {
        this.mTestType = string;
    }

    String getTestType() {
        return this.mTestType;
    }

    void setJarPath(String string) {
        this.mJarPath = string;
    }

    String getJarPath() {
        return this.mJarPath;
    }

    void setIsSignatureCheck(boolean bl) {
        this.mIsSignatureTest = bl;
    }

    boolean isSignatureCheck() {
        return this.mIsSignatureTest;
    }

    void setTestPackageName(String string) {
        this.mTestPackageName = string;
    }

    void setTargetBinaryName(String string) {
        this.mTargetBinaryName = string;
    }

    void setTargetNameSpace(String string) {
        this.mTargetNameSpace = string;
    }

    @Override
    public String getTargetApkName() {
        if (this.mTargetBinaryName != null && !this.mTargetBinaryName.isEmpty()) {
            return String.format("%s.apk", this.mTargetBinaryName);
        }
        return null;
    }

    @Override
    public String getTargetPackageName() {
        if (this.mTargetNameSpace != null && this.mTargetNameSpace.isEmpty()) {
            return null;
        }
        return this.mTargetNameSpace;
    }

    @Override
    public void setExcludedTestFilter(TestFilter testFilter) {
        this.mExcludedTestFilter = testFilter;
    }

    @Override
    public void setClassName(String string, String string2) {
        this.mClassName = string;
        this.mMethodName = string2;
    }

    @Override
    public IRemoteTest createTest(File file) {
        this.mExcludedTestFilter.setTestInclusion(this.mClassName, this.mMethodName);
        this.mTests = this.filterTests();
        if (HOST_SIDE_ONLY_TEST.equals(this.mTestType)) {
            LogUtil.CLog.d((String)"Creating host test for %s", (Object[])new Object[]{this.mName});
            JarHostTest jarHostTest = new JarHostTest();
            jarHostTest.setRunName(this.getUri());
            jarHostTest.setJarFileName(this.mJarPath);
            jarHostTest.setTests(this.mTests);
            this.mDigest = this.generateDigest(file, this.mJarPath);
            return jarHostTest;
        }
        if (VM_HOST_TEST.equals(this.mTestType)) {
            LogUtil.CLog.d((String)"Creating vm host test for %s", (Object[])new Object[]{this.mName});
            VMHostTest vMHostTest = new VMHostTest();
            vMHostTest.setRunName(this.getUri());
            vMHostTest.setJarFileName(this.mJarPath);
            vMHostTest.setTests(this.mTests);
            this.mDigest = this.generateDigest(file, this.mJarPath);
            return vMHostTest;
        }
        if (NATIVE_TEST.equals(this.mTestType)) {
            return new GeeTest(this.mUri, this.mName);
        }
        if (ACCESSIBILITY_TEST.equals(this.mTestType)) {
            AccessibilityTestRunner accessibilityTestRunner = new AccessibilityTestRunner();
            return this.setInstrumentationTest(accessibilityTestRunner, file);
        }
        if (ACCESSIBILITYSERVICE_TEST.equals(this.mTestType)) {
            AccessibilityServiceTestRunner accessibilityServiceTestRunner = new AccessibilityServiceTestRunner();
            return this.setInstrumentationTest(accessibilityServiceTestRunner, file);
        }
        if (UIAUTOMATOR_TEST.equals(this.mTestType)) {
            UiAutomatorJarTest uiAutomatorJarTest = new UiAutomatorJarTest();
            return this.setUiAutomatorTest(uiAutomatorJarTest);
        }
        if (this.mIsSignatureTest) {
            LogUtil.CLog.d((String)"Creating signature test %s", (Object[])new Object[]{this.mName});
            InstrumentationApkTest instrumentationApkTest = new InstrumentationApkTest();
            instrumentationApkTest.setPackageName(this.mAppNameSpace);
            instrumentationApkTest.setRunnerName("android.test.InstrumentationTestRunner");
            instrumentationApkTest.setClassName(SIGNATURE_TEST_CLASS);
            instrumentationApkTest.setMethodName(SIGNATURE_TEST_METHOD);
            TestIdentifier testIdentifier = new TestIdentifier(SIGNATURE_TEST_CLASS, SIGNATURE_TEST_METHOD);
            this.mTests.clear();
            this.mTests.add(testIdentifier);
            instrumentationApkTest.addInstallApk(String.format("%s.apk", this.mName), this.mAppNameSpace);
            this.mDigest = this.generateDigest(file, String.format("%s.apk", this.mName));
            return instrumentationApkTest;
        }
        LogUtil.CLog.d((String)"Creating instrumentation test for %s", (Object[])new Object[]{this.mName});
        InstrumentationApkTest instrumentationApkTest = new InstrumentationApkTest();
        return this.setInstrumentationTest(instrumentationApkTest, file);
    }

    private InstrumentationTest setInstrumentationTest(InstrumentationApkTest instrumentationApkTest, File file) {
        instrumentationApkTest.setRunName(this.getUri());
        instrumentationApkTest.setPackageName(this.mAppNameSpace);
        instrumentationApkTest.setRunnerName(this.mRunner);
        instrumentationApkTest.setTestPackageName(this.mTestPackageName);
        instrumentationApkTest.setClassName(this.mClassName);
        instrumentationApkTest.setMethodName(this.mMethodName);
        instrumentationApkTest.setTestsToRun(this.mTests, !this.mExcludedTestFilter.hasExclusion());
        instrumentationApkTest.addInstallApk(String.format("%s.apk", this.mName), this.mAppNameSpace);
        this.mDigest = this.generateDigest(file, String.format("%s.apk", this.mName));
        if (this.mTests.size() > 1000) {
            instrumentationApkTest.setCollectsTestsShellTimeout(600000);
        }
        return instrumentationApkTest;
    }

    private IRemoteTest setUiAutomatorTest(UiAutomatorJarTest uiAutomatorJarTest) {
        uiAutomatorJarTest.setInstallArtifacts(this.getJarPath());
        if (this.mClassName != null) {
            if (this.mMethodName != null) {
                LogUtil.CLog.logAndDisplay((Log.LogLevel)Log.LogLevel.WARN, (String)"ui automator tests don't currently supportrunning  individual methods", (Object[])new Object[0]);
            }
            uiAutomatorJarTest.addClassName(this.mClassName);
        } else {
            uiAutomatorJarTest.addClassNames(this.mTestClasses);
        }
        uiAutomatorJarTest.setRunName(this.getUri());
        uiAutomatorJarTest.setCaptureLogs(false);
        return uiAutomatorJarTest;
    }

    private Collection<TestIdentifier> filterTests() {
        this.mExcludedTestFilter.setTestInclusion(this.mClassName, this.mMethodName);
        return this.mExcludedTestFilter.filter(this.mTests);
    }

    @Override
    public boolean isKnownTest(TestIdentifier testIdentifier) {
        return this.mTests.contains(testIdentifier);
    }

    @Override
    public boolean isKnownTestClass(String string) {
        return this.mTestClasses.contains(string);
    }

    void addTest(TestIdentifier testIdentifier) {
        this.mTests.add(testIdentifier);
        this.mTestClasses.add(testIdentifier.getClassName());
    }

    @Override
    public Collection<TestIdentifier> getTests() {
        return this.mTests;
    }

    @Override
    public String getDigest() {
        return this.mDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    String generateDigest(File file, String string) {
        block8: {
            String string2;
            InputStream inputStream = null;
            DigestInputStream digestInputStream = null;
            try {
                inputStream = this.getFileStream(file, string);
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                digestInputStream = new DigestInputStream(inputStream, messageDigest);
                byte[] byArray = new byte[8196];
                while (digestInputStream.read(byArray) != -1) {
                }
                string2 = this.toHexString(messageDigest.digest());
                StreamUtil.closeStream((InputStream)digestInputStream);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                String string3 = "SHA-1 not found";
                return string3;
            }
            catch (IOException iOException) {
                LogUtil.CLog.e((Throwable)iOException);
                break block8;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamUtil.closeStream(digestInputStream);
                StreamUtil.closeStream((InputStream)inputStream);
            }
            StreamUtil.closeStream((InputStream)inputStream);
            return string2;
        }
        return "failed to generate digest";
    }

    InputStream getFileStream(File file, String string) throws FileNotFoundException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(file, string)));
        return bufferedInputStream;
    }

    private String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (byte by : byArray) {
            stringBuffer.append(String.format("%02x", by & 0xFF));
        }
        return stringBuffer.toString();
    }
}

