/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.testtype.ITestPlan;
import com.android.cts.tradefed.testtype.TestFilter;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.util.ArrayUtil;
import com.android.tradefed.util.xml.AbstractXmlParser;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPlan
extends AbstractXmlParser
implements ITestPlan {
    private Map<String, TestFilter> mUriExcludedTestsMap;
    private static final String ENTRY_TAG = "Entry";
    private static final String TEST_DELIM = ";";
    private static final String METHOD_DELIM = "#";
    private static final String EXCLUDE_ATTR = "exclude";
    private static final String URI_ATTR = "uri";
    private final String mName;

    public TestPlan(String string) {
        this.mName = string;
        this.mUriExcludedTestsMap = new LinkedHashMap<String, TestFilter>();
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public Collection<String> getTestUris() {
        return this.mUriExcludedTestsMap.keySet();
    }

    @Override
    public TestFilter getExcludedTestFilter(String string) {
        return this.mUriExcludedTestsMap.get(string);
    }

    @Override
    public void addPackage(String string) {
        this.mUriExcludedTestsMap.put(string, new TestFilter());
    }

    protected DefaultHandler createXmlHandler() {
        return new EntryHandler();
    }

    @Override
    public void addExcludedTest(String string, TestIdentifier testIdentifier) {
        TestFilter testFilter = this.mUriExcludedTestsMap.get(string);
        if (testFilter == null) {
            throw new IllegalArgumentException(String.format("Could not find package %s", string));
        }
        testFilter.addExcludedTest(testIdentifier);
    }

    @Override
    public void addExcludedTests(String string, Collection<TestIdentifier> collection) {
        TestFilter testFilter = this.mUriExcludedTestsMap.get(string);
        if (testFilter == null) {
            throw new IllegalArgumentException(String.format("Could not find package %s", string));
        }
        testFilter.getExcludedTests().addAll(collection);
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        KXmlSerializer kXmlSerializer = new KXmlSerializer();
        kXmlSerializer.setOutput(outputStream, "UTF-8");
        kXmlSerializer.startDocument("UTF-8", Boolean.valueOf(false));
        kXmlSerializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
        kXmlSerializer.startTag(null, "TestPlan");
        kXmlSerializer.attribute(null, "version", "1.0");
        for (Map.Entry<String, TestFilter> entry : this.mUriExcludedTestsMap.entrySet()) {
            kXmlSerializer.startTag(null, ENTRY_TAG);
            kXmlSerializer.attribute(null, URI_ATTR, entry.getKey());
            this.serializeFilter(kXmlSerializer, entry.getValue());
            kXmlSerializer.endTag(null, ENTRY_TAG);
        }
        kXmlSerializer.endTag(null, "TestPlan");
        kXmlSerializer.endDocument();
    }

    private void serializeFilter(KXmlSerializer kXmlSerializer, TestFilter testFilter) throws IOException {
        if (!testFilter.hasExclusion()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(testFilter.getExcludedClasses());
        for (TestIdentifier testIdentifier : testFilter.getExcludedTests()) {
            arrayList.add(testIdentifier.toString());
        }
        String string = ArrayUtil.join((String)TEST_DELIM, (Object[])new Object[]{arrayList});
        kXmlSerializer.attribute(null, EXCLUDE_ATTR, string);
    }

    private class EntryHandler
    extends DefaultHandler {
        private EntryHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (TestPlan.ENTRY_TAG.equals(string2)) {
                String string4 = attributes.getValue(TestPlan.URI_ATTR);
                TestFilter testFilter = this.parseExcludedTests(attributes.getValue(TestPlan.EXCLUDE_ATTR));
                TestPlan.this.mUriExcludedTestsMap.put(string4, testFilter);
            }
        }

        private TestFilter parseExcludedTests(String string) {
            TestFilter testFilter = new TestFilter();
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(TestPlan.TEST_DELIM)) {
                    String[] stringArray2 = string2.split(TestPlan.METHOD_DELIM);
                    if (stringArray2.length == 2) {
                        testFilter.addExcludedTest(new TestIdentifier(stringArray2[0], stringArray2[1]));
                        continue;
                    }
                    testFilter.addExcludedClass(string2);
                }
            }
            return testFilter;
        }
    }
}

