/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.tradefed.build.IBuildInfo;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.IBuildReceiver;
import com.android.tradefed.testtype.UiAutomatorTest;
import java.io.FileNotFoundException;
import java.util.Arrays;
import junit.framework.Assert;

public class UiAutomatorJarTest
extends UiAutomatorTest
implements IBuildReceiver {
    private static final String SHELL_EXE_BASE = "/data/local/tmp/";
    private String mTestJarFileName;
    private CtsBuildHelper mCtsBuild = null;

    public void setBuild(IBuildInfo iBuildInfo) {
        this.mCtsBuild = CtsBuildHelper.createBuildHelper(iBuildInfo);
    }

    public void setInstallArtifacts(String string) {
        this.mTestJarFileName = string;
    }

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        Assert.assertNotNull((String)"missing device", (Object)this.getDevice());
        Assert.assertNotNull((String)"missing build", (Object)this.mCtsBuild);
        Assert.assertNotNull((String)"missing jar to install", (Object)this.mTestJarFileName);
        this.installJar();
        super.run(iTestInvocationListener);
        this.uninstallJar();
    }

    private void installJar() throws DeviceNotAvailableException {
        LogUtil.CLog.d((String)"Installing %s on %s", (Object[])new Object[]{this.mTestJarFileName, this.getDevice().getSerialNumber()});
        String string = String.format("%s%s", SHELL_EXE_BASE, this.mTestJarFileName);
        try {
            boolean bl = this.getDevice().pushFile(this.mCtsBuild.getTestApp(this.mTestJarFileName), string);
            Assert.assertTrue((String)String.format("Failed to push file to %s", string), (boolean)bl);
            this.setTestJarPaths(Arrays.asList(string));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Assert.fail((String)String.format("Could not find file %s", this.mTestJarFileName));
        }
    }

    private void uninstallJar() throws DeviceNotAvailableException {
        LogUtil.CLog.d((String)"Uninstalling %s on %s", (Object[])new Object[]{this.mTestJarFileName, this.getDevice().getSerialNumber()});
        String string = String.format("%s%s", SHELL_EXE_BASE, this.mTestJarFileName);
        this.getDevice().executeShellCommand(String.format("rm %s", string));
    }
}

