/*
 * Decompiled with CFR 0.152.
 */
package com.android.cts.tradefed.testtype;

import com.android.cts.tradefed.build.CtsBuildHelper;
import com.android.cts.tradefed.testtype.JarHostTest;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.log.LogUtil;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipFile;

public class VMHostTest
extends JarHostTest {
    private static final String VM_TEST_TEMP_DIR = "/data/local/tmp/vm-tests";

    public void run(ITestInvocationListener iTestInvocationListener) throws DeviceNotAvailableException {
        if (!this.installVmPrereqs(this.getDevice(), this.getBuildHelper())) {
            throw new RuntimeException(String.format("Failed to install vm-tests prereqs on device %s", this.getDevice().getSerialNumber()));
        }
        super.run(iTestInvocationListener);
        this.cleanupDeviceFiles(this.getDevice());
    }

    private boolean installVmPrereqs(ITestDevice iTestDevice, CtsBuildHelper ctsBuildHelper) throws DeviceNotAvailableException {
        this.cleanupDeviceFiles(iTestDevice);
        LogUtil.CLog.d((String)"Creating device temp directory, including dalvik-cache.");
        this.createRemoteDir(iTestDevice, "/data/local/tmp/vm-tests/dalvik-cache");
        try {
            File file = FileUtil.createTempDir((String)"cts-vm", (File)new File("/tmp/"));
            LogUtil.CLog.d((String)"Creating host temp dir %s", (Object[])new Object[]{file.getPath()});
            File file2 = new File(ctsBuildHelper.getTestCasesDir(), this.getJarFileName());
            if (!file2.exists()) {
                LogUtil.CLog.e((String)"Missing jar file %s", (Object[])new Object[]{file2.getPath()});
                return false;
            }
            LogUtil.CLog.d((String)"Extracting jar file %s to host temp directory %s.", (Object[])new Object[]{file2.getPath(), file.getPath()});
            ZipFile zipFile = new ZipFile(file2);
            FileUtil.extractZip((ZipFile)zipFile, (File)file);
            File file3 = new File(file, "tests");
            LogUtil.CLog.d((String)"Syncing host dir %s to device dir %s", (Object[])new Object[]{file3.getPath(), VM_TEST_TEMP_DIR});
            if (!iTestDevice.pushDir(file3, VM_TEST_TEMP_DIR)) {
                LogUtil.CLog.e((String)"Failed to push vm test files");
                return false;
            }
            LogUtil.CLog.d((String)"Cleaning up host temp dir %s", (Object[])new Object[]{file.getPath()});
            FileUtil.recursiveDelete((File)file);
        }
        catch (IOException iOException) {
            LogUtil.CLog.e((String)"Failed to extract jar file %s and sync it to device %s.", (Object[])new Object[]{this.getJarFileName(), iTestDevice.getSerialNumber()});
            return false;
        }
        return true;
    }

    private void cleanupDeviceFiles(ITestDevice iTestDevice) throws DeviceNotAvailableException {
        if (iTestDevice.doesFileExist(VM_TEST_TEMP_DIR)) {
            LogUtil.CLog.d((String)"Removing device's temp dir %s from previous runs.", (Object[])new Object[]{VM_TEST_TEMP_DIR});
            iTestDevice.executeShellCommand(String.format("rm -r %s", VM_TEST_TEMP_DIR));
        }
    }

    private void createRemoteDir(ITestDevice iTestDevice, String string) throws DeviceNotAvailableException {
        if (iTestDevice.doesFileExist(string)) {
            return;
        }
        File file = new File(string);
        String string2 = file.getParent();
        if (string2 != null) {
            this.createRemoteDir(iTestDevice, string2);
        }
        iTestDevice.executeShellCommand(String.format("mkdir %s", string));
    }
}

