/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IDevice;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.InvalidParameterException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmulatorConsole {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int WAIT_TIME = 5;
    private static final int STD_TIMEOUT = 5000;
    private static final String HOST = "127.0.0.1";
    private static final String COMMAND_PING = "help\r\n";
    private static final String COMMAND_AVD_NAME = "avd name\r\n";
    private static final String COMMAND_KILL = "kill\r\n";
    private static final String COMMAND_GSM_STATUS = "gsm status\r\n";
    private static final String COMMAND_GSM_CALL = "gsm call %1$s\r\n";
    private static final String COMMAND_GSM_CANCEL_CALL = "gsm cancel %1$s\r\n";
    private static final String COMMAND_GSM_DATA = "gsm data %1$s\r\n";
    private static final String COMMAND_GSM_VOICE = "gsm voice %1$s\r\n";
    private static final String COMMAND_SMS_SEND = "sms send %1$s %2$s\r\n";
    private static final String COMMAND_NETWORK_STATUS = "network status\r\n";
    private static final String COMMAND_NETWORK_SPEED = "network speed %1$s\r\n";
    private static final String COMMAND_NETWORK_LATENCY = "network delay %1$s\r\n";
    private static final String COMMAND_GPS = "geo fix %1$f %2$f %3$f\r\n";
    private static final Pattern RE_KO = Pattern.compile("KO:\\s+(.*)");
    public static final int[] MIN_LATENCIES = new int[]{0, 150, 80, 35};
    public final int[] DOWNLOAD_SPEEDS = new int[]{0, 14400, 43200, 80000, 236800, 1920000, 14400000};
    public static final String[] NETWORK_SPEEDS = new String[]{"full", "gsm", "hscsd", "gprs", "edge", "umts", "hsdpa"};
    public static final String[] NETWORK_LATENCIES = new String[]{"none", "gprs", "edge", "umts"};
    public static final String RESULT_OK = null;
    private static final Pattern sEmulatorRegexp = Pattern.compile("emulator-(\\d+)");
    private static final Pattern sVoiceStatusRegexp = Pattern.compile("gsm\\s+voice\\s+state:\\s*([a-z]+)", 2);
    private static final Pattern sDataStatusRegexp = Pattern.compile("gsm\\s+data\\s+state:\\s*([a-z]+)", 2);
    private static final Pattern sDownloadSpeedRegexp = Pattern.compile("\\s+download\\s+speed:\\s+(\\d+)\\s+bits.*", 2);
    private static final Pattern sMinLatencyRegexp = Pattern.compile("\\s+minimum\\s+latency:\\s+(\\d+)\\s+ms", 2);
    private static final HashMap<Integer, EmulatorConsole> sEmulators = new HashMap();
    private int mPort;
    private SocketChannel mSocketChannel;
    private byte[] mBuffer = new byte[1024];

    public static synchronized EmulatorConsole getConsole(IDevice iDevice) {
        Integer n = EmulatorConsole.getEmulatorPort(iDevice.getSerialNumber());
        if (n == null) {
            return null;
        }
        EmulatorConsole emulatorConsole = sEmulators.get(n);
        if (emulatorConsole != null && !emulatorConsole.ping()) {
            EmulatorConsole.RemoveConsole(emulatorConsole.mPort);
            emulatorConsole = null;
        }
        if (emulatorConsole == null) {
            emulatorConsole = new EmulatorConsole(n);
            if (emulatorConsole.start()) {
                sEmulators.put(n, emulatorConsole);
            } else {
                emulatorConsole = null;
            }
        }
        return emulatorConsole;
    }

    public static Integer getEmulatorPort(String string) {
        Matcher matcher = sEmulatorRegexp.matcher(string);
        if (matcher.matches()) {
            try {
                int n = Integer.parseInt(matcher.group(1));
                if (n > 0) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static synchronized void RemoveConsole(int n) {
        sEmulators.remove(n);
    }

    private EmulatorConsole(int n) {
        this.mPort = n;
    }

    private boolean start() {
        InetSocketAddress inetSocketAddress;
        try {
            InetAddress inetAddress = InetAddress.getByName(HOST);
            inetSocketAddress = new InetSocketAddress(inetAddress, this.mPort);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        try {
            this.mSocketChannel = SocketChannel.open(inetSocketAddress);
        }
        catch (IOException iOException) {
            return false;
        }
        this.readLines();
        return true;
    }

    private synchronized boolean ping() {
        if (this.sendCommand(COMMAND_PING)) {
            return this.readLines() != null;
        }
        return false;
    }

    public synchronized void kill() {
        if (this.sendCommand(COMMAND_KILL)) {
            EmulatorConsole.RemoveConsole(this.mPort);
        }
    }

    public synchronized String getAvdName() {
        if (this.sendCommand(COMMAND_AVD_NAME)) {
            String[] stringArray = this.readLines();
            if (stringArray != null && stringArray.length == 2) {
                return stringArray[0];
            }
            Matcher matcher = RE_KO.matcher(stringArray[stringArray.length - 1]);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    public synchronized NetworkStatus getNetworkStatus() {
        String[] stringArray;
        if (this.sendCommand(COMMAND_NETWORK_STATUS) && this.isValid(stringArray = this.readLines())) {
            NetworkStatus networkStatus = new NetworkStatus();
            for (String string : stringArray) {
                String string2;
                Matcher matcher = sDownloadSpeedRegexp.matcher(string);
                if (matcher.matches()) {
                    string2 = matcher.group(1);
                    networkStatus.speed = this.getSpeedIndex(string2);
                    continue;
                }
                matcher = sMinLatencyRegexp.matcher(string);
                if (!matcher.matches()) continue;
                string2 = matcher.group(1);
                networkStatus.latency = this.getLatencyIndex(string2);
            }
            return networkStatus;
        }
        return null;
    }

    public synchronized GsmStatus getGsmStatus() {
        String[] stringArray;
        if (this.sendCommand(COMMAND_GSM_STATUS) && this.isValid(stringArray = this.readLines())) {
            GsmStatus gsmStatus = new GsmStatus();
            for (String string : stringArray) {
                String string2;
                Matcher matcher = sVoiceStatusRegexp.matcher(string);
                if (matcher.matches()) {
                    string2 = matcher.group(1);
                    gsmStatus.voice = GsmMode.getEnum(string2.toLowerCase(Locale.US));
                    continue;
                }
                matcher = sDataStatusRegexp.matcher(string);
                if (!matcher.matches()) continue;
                string2 = matcher.group(1);
                gsmStatus.data = GsmMode.getEnum(string2.toLowerCase(Locale.US));
            }
            return gsmStatus;
        }
        return null;
    }

    public synchronized String setGsmVoiceMode(GsmMode gsmMode) throws InvalidParameterException {
        if (gsmMode == GsmMode.UNKNOWN) {
            throw new InvalidParameterException();
        }
        String string = String.format(COMMAND_GSM_VOICE, gsmMode.getTag());
        return this.processCommand(string);
    }

    public synchronized String setGsmDataMode(GsmMode gsmMode) throws InvalidParameterException {
        if (gsmMode == GsmMode.UNKNOWN) {
            throw new InvalidParameterException();
        }
        String string = String.format(COMMAND_GSM_DATA, gsmMode.getTag());
        return this.processCommand(string);
    }

    public synchronized String call(String string) {
        String string2 = String.format(COMMAND_GSM_CALL, string);
        return this.processCommand(string2);
    }

    public synchronized String cancelCall(String string) {
        String string2 = String.format(COMMAND_GSM_CANCEL_CALL, string);
        return this.processCommand(string2);
    }

    public synchronized String sendSms(String string, String string2) {
        String string3 = String.format(COMMAND_SMS_SEND, string, string2);
        return this.processCommand(string3);
    }

    public synchronized String setNetworkSpeed(int n) {
        String string = String.format(COMMAND_NETWORK_SPEED, NETWORK_SPEEDS[n]);
        return this.processCommand(string);
    }

    public synchronized String setNetworkLatency(int n) {
        String string = String.format(COMMAND_NETWORK_LATENCY, NETWORK_LATENCIES[n]);
        return this.processCommand(string);
    }

    public synchronized String sendLocation(double d, double d2, double d3) {
        Formatter formatter = new Formatter(Locale.US);
        formatter.format(COMMAND_GPS, d, d2, d3);
        return this.processCommand(formatter.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendCommand(String string) {
        boolean bl = false;
        try {
            byte[] byArray;
            try {
                byArray = string.getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                boolean bl2 = bl;
                if (!bl) {
                    EmulatorConsole.RemoveConsole(this.mPort);
                }
                return bl2;
            }
            AdbHelper.write(this.mSocketChannel, byArray, byArray.length, DdmPreferences.getTimeOut());
            bl = true;
        }
        catch (Exception exception) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (!bl) {
                EmulatorConsole.RemoveConsole(this.mPort);
            }
        }
        return bl;
    }

    private String processCommand(String string) {
        if (this.sendCommand(string)) {
            String[] stringArray = this.readLines();
            if (stringArray != null && stringArray.length > 0) {
                Matcher matcher = RE_KO.matcher(stringArray[stringArray.length - 1]);
                if (matcher.matches()) {
                    return matcher.group(1);
                }
                return RESULT_OK;
            }
            return "Unable to communicate with the emulator";
        }
        return "Unable to send command to the emulator";
    }

    private String[] readLines() {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.mBuffer, 0, this.mBuffer.length);
            int n = 0;
            boolean bl = false;
            while (byteBuffer.position() != byteBuffer.limit() && !bl) {
                int n2;
                int n3 = this.mSocketChannel.read(byteBuffer);
                if (n3 < 0) {
                    return null;
                }
                if (n3 == 0) {
                    if (n * 5 > 5000) {
                        return null;
                    }
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++n;
                } else {
                    n = 0;
                }
                if (byteBuffer.position() < 4 || !this.endsWithOK(n2 = byteBuffer.position()) && !this.lastLineIsKO(n2)) continue;
                bl = true;
            }
            String string = new String(this.mBuffer, 0, byteBuffer.position(), DEFAULT_ENCODING);
            return string.split("\r\n");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean endsWithOK(int n) {
        return this.mBuffer[n - 1] == 10 && this.mBuffer[n - 2] == 13 && this.mBuffer[n - 3] == 75 && this.mBuffer[n - 4] == 79;
    }

    private boolean lastLineIsKO(int n) {
        if (this.mBuffer[n - 1] != 10 || this.mBuffer[n - 2] != 13) {
            return false;
        }
        int n2 = 0;
        for (n2 = n - 3; n2 >= 0 && (this.mBuffer[n2] != 10 || n2 <= 0 || this.mBuffer[n2 - 1] != 13); --n2) {
        }
        return this.mBuffer[n2 + 1] == 75 && this.mBuffer[n2 + 2] == 79;
    }

    private boolean isValid(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            return !RE_KO.matcher(stringArray[stringArray.length - 1]).matches();
        }
        return false;
    }

    private int getLatencyIndex(String string) {
        try {
            int n = Integer.parseInt(string);
            for (int i = 0; i < MIN_LATENCIES.length; ++i) {
                if (MIN_LATENCIES[i] != n) continue;
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    private int getSpeedIndex(String string) {
        try {
            int n = Integer.parseInt(string);
            for (int i = 0; i < this.DOWNLOAD_SPEEDS.length; ++i) {
                if (this.DOWNLOAD_SPEEDS[i] != n) continue;
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    public static class NetworkStatus {
        public int speed = -1;
        public int latency = -1;
    }

    public static class GsmStatus {
        public GsmMode voice = GsmMode.UNKNOWN;
        public GsmMode data = GsmMode.UNKNOWN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GsmMode {
        UNKNOWN((String)null),
        UNREGISTERED(new String[]{"unregistered", "off"}),
        HOME(new String[]{"home", "on"}),
        ROAMING("roaming"),
        SEARCHING("searching"),
        DENIED("denied");

        private final String[] tags;

        private GsmMode(String string2) {
            this.tags = string2 != null ? new String[]{string2} : new String[0];
        }

        private GsmMode(String[] stringArray) {
            this.tags = stringArray;
        }

        public static GsmMode getEnum(String string) {
            for (GsmMode gsmMode : GsmMode.values()) {
                for (String string2 : gsmMode.tags) {
                    if (!string2.equals(string)) continue;
                    return gsmMode;
                }
            }
            return UNKNOWN;
        }

        public String getTag() {
            if (this.tags.length > 0) {
                return this.tags[0];
            }
            return null;
        }
    }
}

