/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Device;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileListingService {
    private static final Pattern sApkPattern = Pattern.compile(".*\\.apk", 2);
    private static final String PM_FULL_LISTING = "pm list packages -f";
    private static final Pattern sPmPattern = Pattern.compile("^package:(.+?)=(.+)$");
    public static final String DIRECTORY_DATA = "data";
    public static final String DIRECTORY_SDCARD = "sdcard";
    public static final String DIRECTORY_MNT = "mnt";
    public static final String DIRECTORY_SYSTEM = "system";
    public static final String DIRECTORY_TEMP = "tmp";
    public static final String DIRECTORY_APP = "app";
    public static final long REFRESH_RATE = 5000L;
    static final long REFRESH_TEST = 4000L;
    public static final int TYPE_FILE = 0;
    public static final int TYPE_DIRECTORY = 1;
    public static final int TYPE_DIRECTORY_LINK = 2;
    public static final int TYPE_BLOCK = 3;
    public static final int TYPE_CHARACTER = 4;
    public static final int TYPE_LINK = 5;
    public static final int TYPE_SOCKET = 6;
    public static final int TYPE_FIFO = 7;
    public static final int TYPE_OTHER = 8;
    public static final String FILE_SEPARATOR = "/";
    private static final String FILE_ROOT = "/";
    private static Pattern sLsPattern = Pattern.compile("^([bcdlsp-][-r][-w][-xsS][-r][-w][-xsS][-r][-w][-xstST])\\s+(\\S+)\\s+(\\S+)\\s+([\\d\\s,]*)\\s+(\\d{4}-\\d\\d-\\d\\d)\\s+(\\d\\d:\\d\\d)\\s+(.*)$");
    private Device mDevice;
    private FileEntry mRoot;
    private ArrayList<Thread> mThreadList = new ArrayList();

    FileListingService(Device device) {
        this.mDevice = device;
    }

    public FileEntry getRoot() {
        if (this.mDevice != null) {
            if (this.mRoot == null) {
                this.mRoot = new FileEntry(null, "", 1, true);
            }
            return this.mRoot;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileEntry[] getChildren(final FileEntry fileEntry, boolean bl, final IListingReceiver iListingReceiver) {
        if (bl && !fileEntry.needFetch()) {
            return fileEntry.getCachedChildren();
        }
        if (iListingReceiver == null) {
            this.doLs(fileEntry);
            return fileEntry.getCachedChildren();
        }
        Thread thread = new Thread("ls " + fileEntry.getFullPath()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object;
                Cloneable cloneable;
                FileListingService.this.doLs(fileEntry);
                iListingReceiver.setChildren(fileEntry, fileEntry.getCachedChildren());
                FileEntry[] fileEntryArray = fileEntry.getCachedChildren();
                if (fileEntryArray.length > 0 && fileEntryArray[0].isApplicationPackage()) {
                    cloneable = new HashMap();
                    for (FileEntry fileEntry2 : fileEntryArray) {
                        String string = fileEntry2.getFullPath();
                        ((HashMap)cloneable).put(string, fileEntry2);
                    }
                    object = FileListingService.PM_FULL_LISTING;
                    try {
                        FileListingService.this.mDevice.executeShellCommand((String)object, new MultiLineReceiver((HashMap)cloneable){
                            final /* synthetic */ HashMap val$map;
                            {
                                this.val$map = hashMap;
                            }

                            public void processNewLines(String[] stringArray) {
                                for (String string : stringArray) {
                                    FileEntry fileEntry;
                                    Matcher matcher;
                                    if (string.length() <= 0 || !(matcher = sPmPattern.matcher(string)).matches() || (fileEntry = (FileEntry)this.val$map.get(matcher.group(1))) == null) continue;
                                    fileEntry.info = matcher.group(2);
                                    iListingReceiver.refreshEntry(fileEntry);
                                }
                            }

                            public boolean isCancelled() {
                                return false;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                cloneable = FileListingService.this.mThreadList;
                synchronized (cloneable) {
                    FileListingService.this.mThreadList.remove(this);
                    if (FileListingService.this.mThreadList.size() > 0) {
                        object = (Thread)FileListingService.this.mThreadList.get(0);
                        ((Thread)object).start();
                    }
                }
            }
        };
        ArrayList<Thread> arrayList = this.mThreadList;
        synchronized (arrayList) {
            this.mThreadList.add(thread);
            if (this.mThreadList.size() == 1) {
                thread.start();
            }
        }
        return null;
    }

    public FileEntry[] getChildrenSync(FileEntry fileEntry) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        this.doLsAndThrow(fileEntry);
        return fileEntry.getCachedChildren();
    }

    private void doLs(FileEntry fileEntry) {
        try {
            this.doLsAndThrow(fileEntry);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLsAndThrow(FileEntry fileEntry) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        ArrayList<FileEntry> arrayList = new ArrayList<FileEntry>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        try {
            String string = "ls -l " + fileEntry.getFullEscapedPath();
            LsReceiver lsReceiver = new LsReceiver(fileEntry, arrayList, arrayList2);
            this.mDevice.executeShellCommand(string, lsReceiver);
            lsReceiver.finishLinks();
        }
        finally {
            fileEntry.fetchTime = System.currentTimeMillis();
            Collections.sort(arrayList, FileEntry.sEntryComparator);
            fileEntry.setChildren(arrayList);
        }
    }

    public static interface IListingReceiver {
        public void setChildren(FileEntry var1, FileEntry[] var2);

        public void refreshEntry(FileEntry var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LsReceiver
    extends MultiLineReceiver {
        private ArrayList<FileEntry> mEntryList;
        private ArrayList<String> mLinkList;
        private FileEntry[] mCurrentChildren;
        private FileEntry mParentEntry;

        public LsReceiver(FileEntry fileEntry, ArrayList<FileEntry> arrayList, ArrayList<String> arrayList2) {
            this.mParentEntry = fileEntry;
            this.mCurrentChildren = fileEntry.getCachedChildren();
            this.mEntryList = arrayList;
            this.mLinkList = arrayList2;
        }

        @Override
        public void processNewLines(String[] stringArray) {
            for (String string : stringArray) {
                Object object;
                Matcher matcher;
                if (string.length() == 0 || !(matcher = sLsPattern.matcher(string)).matches()) continue;
                String string2 = matcher.group(7);
                String string3 = matcher.group(1);
                String string4 = matcher.group(2);
                String string5 = matcher.group(3);
                String string6 = matcher.group(4);
                String string7 = matcher.group(5);
                String string8 = matcher.group(6);
                String string9 = null;
                int n = 8;
                switch (string3.charAt(0)) {
                    case '-': {
                        n = 0;
                        break;
                    }
                    case 'b': {
                        n = 3;
                        break;
                    }
                    case 'c': {
                        n = 4;
                        break;
                    }
                    case 'd': {
                        n = 1;
                        break;
                    }
                    case 'l': {
                        n = 5;
                        break;
                    }
                    case 's': {
                        n = 6;
                        break;
                    }
                    case 'p': {
                        n = 7;
                    }
                }
                if (n == 5) {
                    object = string2.split("\\s->\\s");
                    if (((String[])object).length == 2) {
                        string2 = object[0];
                        string9 = object[1];
                        String[] stringArray2 = string9.split("/");
                        if (stringArray2.length == 1 && "..".equals(stringArray2[0])) {
                            n = 2;
                        }
                    }
                    string9 = "-> " + string9;
                }
                if ((object = this.getExistingEntry(string2)) == null) {
                    object = new FileEntry(this.mParentEntry, string2, n, false);
                }
                object.permissions = string3;
                object.size = string6;
                object.date = string7;
                object.time = string8;
                object.owner = string4;
                object.group = string5;
                if (n == 5) {
                    object.info = string9;
                }
                this.mEntryList.add((FileEntry)object);
            }
        }

        private FileEntry getExistingEntry(String string) {
            for (int i = 0; i < this.mCurrentChildren.length; ++i) {
                FileEntry fileEntry = this.mCurrentChildren[i];
                if (fileEntry == null || !string.equals(fileEntry.name)) continue;
                this.mCurrentChildren[i] = null;
                return fileEntry;
            }
            return null;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        public void finishLinks() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FileEntry {
        private static final Pattern sEscapePattern = Pattern.compile("([\\\\()*+?\"'#/\\s])");
        private static Comparator<FileEntry> sEntryComparator = new Comparator<FileEntry>(){

            @Override
            public int compare(FileEntry fileEntry, FileEntry fileEntry2) {
                if (fileEntry instanceof FileEntry && fileEntry2 instanceof FileEntry) {
                    FileEntry fileEntry3 = fileEntry;
                    FileEntry fileEntry4 = fileEntry2;
                    return fileEntry3.name.compareTo(fileEntry4.name);
                }
                return 0;
            }
        };
        FileEntry parent;
        String name;
        String info;
        String permissions;
        String size;
        String date;
        String time;
        String owner;
        String group;
        int type;
        boolean isAppPackage;
        boolean isRoot;
        long fetchTime = 0L;
        final ArrayList<FileEntry> mChildren = new ArrayList();

        private FileEntry(FileEntry fileEntry, String string, int n, boolean bl) {
            this.parent = fileEntry;
            this.name = string;
            this.type = n;
            this.isRoot = bl;
            this.checkAppPackageStatus();
        }

        public String getName() {
            return this.name;
        }

        public String getSize() {
            return this.size;
        }

        public int getSizeValue() {
            return Integer.parseInt(this.size);
        }

        public String getDate() {
            return this.date;
        }

        public String getTime() {
            return this.time;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public String getInfo() {
            return this.info;
        }

        public String getFullPath() {
            if (this.isRoot) {
                return "/";
            }
            StringBuilder stringBuilder = new StringBuilder();
            this.fillPathBuilder(stringBuilder, false);
            return stringBuilder.toString();
        }

        public String getFullEscapedPath() {
            StringBuilder stringBuilder = new StringBuilder();
            this.fillPathBuilder(stringBuilder, true);
            return stringBuilder.toString();
        }

        public String[] getPathSegments() {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.fillPathSegments(arrayList);
            return arrayList.toArray(new String[arrayList.size()]);
        }

        public int getType() {
            return this.type;
        }

        public boolean isDirectory() {
            return this.type == 1 || this.type == 2;
        }

        public FileEntry getParent() {
            return this.parent;
        }

        public FileEntry[] getCachedChildren() {
            return this.mChildren.toArray(new FileEntry[this.mChildren.size()]);
        }

        public FileEntry findChild(String string) {
            for (FileEntry fileEntry : this.mChildren) {
                if (!fileEntry.name.equals(string)) continue;
                return fileEntry;
            }
            return null;
        }

        public boolean isRoot() {
            return this.isRoot;
        }

        void addChild(FileEntry fileEntry) {
            this.mChildren.add(fileEntry);
        }

        void setChildren(ArrayList<FileEntry> arrayList) {
            this.mChildren.clear();
            this.mChildren.addAll(arrayList);
        }

        boolean needFetch() {
            if (this.fetchTime == 0L) {
                return true;
            }
            long l = System.currentTimeMillis();
            return l - this.fetchTime > 4000L;
        }

        public boolean isApplicationPackage() {
            return this.isAppPackage;
        }

        public boolean isAppFileName() {
            Matcher matcher = sApkPattern.matcher(this.name);
            return matcher.matches();
        }

        protected void fillPathBuilder(StringBuilder stringBuilder, boolean bl) {
            if (this.isRoot) {
                return;
            }
            if (this.parent != null) {
                this.parent.fillPathBuilder(stringBuilder, bl);
            }
            stringBuilder.append("/");
            stringBuilder.append(bl ? FileEntry.escape(this.name) : this.name);
        }

        protected void fillPathSegments(ArrayList<String> arrayList) {
            if (this.isRoot) {
                return;
            }
            if (this.parent != null) {
                this.parent.fillPathSegments(arrayList);
            }
            arrayList.add(this.name);
        }

        private void checkAppPackageStatus() {
            this.isAppPackage = false;
            String[] stringArray = this.getPathSegments();
            if (this.type == 0 && stringArray.length == 3 && this.isAppFileName()) {
                this.isAppPackage = FileListingService.DIRECTORY_APP.equals(stringArray[1]) && (FileListingService.DIRECTORY_SYSTEM.equals(stringArray[0]) || FileListingService.DIRECTORY_DATA.equals(stringArray[0]));
            }
        }

        public static String escape(String string) {
            return sEscapePattern.matcher(string).replaceAll("\\\\$1");
        }
    }
}

