/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.NativeStackCallInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NativeAllocationInfo {
    public static final String END_STACKTRACE_KW = "EndStacktrace";
    public static final String BEGIN_STACKTRACE_KW = "BeginStacktrace:";
    public static final String TOTAL_SIZE_KW = "TotalSize:";
    public static final String SIZE_KW = "Size:";
    public static final String ALLOCATIONS_KW = "Allocations:";
    private static final int FLAG_ZYGOTE_CHILD = Integer.MIN_VALUE;
    private static final int FLAG_MASK = Integer.MIN_VALUE;
    private static final List<String> FILTERED_LIBRARIES = Arrays.asList("libc.so", "libc_malloc_debug_leak.so");
    private static final List<Pattern> FILTERED_METHOD_NAME_PATTERNS = Arrays.asList(Pattern.compile("malloc", 2), Pattern.compile("calloc", 2), Pattern.compile("realloc", 2), Pattern.compile("operator new", 2), Pattern.compile("memalign", 2));
    private final int mSize;
    private final boolean mIsZygoteChild;
    private final int mAllocations;
    private final ArrayList<Long> mStackCallAddresses = new ArrayList();
    private ArrayList<NativeStackCallInfo> mResolvedStackCall = null;
    private boolean mIsStackCallResolved = false;

    public NativeAllocationInfo(int n, int n2) {
        this.mSize = n & Integer.MAX_VALUE;
        this.mIsZygoteChild = (n & Integer.MIN_VALUE) != 0;
        this.mAllocations = n2;
    }

    public void addStackCallAddress(long l) {
        this.mStackCallAddresses.add(l);
    }

    public int getSize() {
        return this.mSize;
    }

    public boolean isZygoteChild() {
        return this.mIsZygoteChild;
    }

    public int getAllocationCount() {
        return this.mAllocations;
    }

    public boolean isStackCallResolved() {
        return this.mIsStackCallResolved;
    }

    public List<Long> getStackCallAddresses() {
        return this.mStackCallAddresses;
    }

    public synchronized void setResolvedStackCall(List<NativeStackCallInfo> list) {
        if (this.mResolvedStackCall == null) {
            this.mResolvedStackCall = new ArrayList();
        } else {
            this.mResolvedStackCall.clear();
        }
        this.mResolvedStackCall.addAll(list);
        this.mIsStackCallResolved = this.mResolvedStackCall.size() != 0;
    }

    public synchronized List<NativeStackCallInfo> getResolvedStackCall() {
        if (this.mIsStackCallResolved) {
            return this.mResolvedStackCall;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NativeAllocationInfo) {
            NativeAllocationInfo nativeAllocationInfo = (NativeAllocationInfo)object;
            if (this.mSize != nativeAllocationInfo.mSize || this.mAllocations != nativeAllocationInfo.mAllocations || this.mStackCallAddresses.size() != nativeAllocationInfo.mStackCallAddresses.size()) {
                return false;
            }
            int n = this.mStackCallAddresses.size();
            for (int i = 0; i < n; ++i) {
                long l;
                long l2 = this.mStackCallAddresses.get(i);
                if (l2 == (l = nativeAllocationInfo.mStackCallAddresses.get(i).longValue())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.mSize;
        n = 31 * n + this.mAllocations;
        n = 31 * n + this.mStackCallAddresses.size();
        for (long l : this.mStackCallAddresses) {
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ALLOCATIONS_KW);
        stringBuffer.append(' ');
        stringBuffer.append(this.mAllocations);
        stringBuffer.append('\n');
        stringBuffer.append(SIZE_KW);
        stringBuffer.append(' ');
        stringBuffer.append(this.mSize);
        stringBuffer.append('\n');
        stringBuffer.append(TOTAL_SIZE_KW);
        stringBuffer.append(' ');
        stringBuffer.append(this.mSize * this.mAllocations);
        stringBuffer.append('\n');
        if (this.mResolvedStackCall != null) {
            stringBuffer.append(BEGIN_STACKTRACE_KW);
            stringBuffer.append('\n');
            for (NativeStackCallInfo nativeStackCallInfo : this.mResolvedStackCall) {
                long l = nativeStackCallInfo.getAddress();
                if (l == 0L) continue;
                if (nativeStackCallInfo.getLineNumber() != -1) {
                    stringBuffer.append(String.format("\t%1$08x\t%2$s --- %3$s --- %4$s:%5$d\n", l, nativeStackCallInfo.getLibraryName(), nativeStackCallInfo.getMethodName(), nativeStackCallInfo.getSourceFile(), nativeStackCallInfo.getLineNumber()));
                    continue;
                }
                stringBuffer.append(String.format("\t%1$08x\t%2$s --- %3$s --- %4$s\n", l, nativeStackCallInfo.getLibraryName(), nativeStackCallInfo.getMethodName(), nativeStackCallInfo.getSourceFile()));
            }
            stringBuffer.append(END_STACKTRACE_KW);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public synchronized NativeStackCallInfo getRelevantStackCallInfo() {
        if (this.mIsStackCallResolved && this.mResolvedStackCall != null) {
            for (NativeStackCallInfo nativeStackCallInfo : this.mResolvedStackCall) {
                if (!this.isRelevantLibrary(nativeStackCallInfo.getLibraryName()) || !this.isRelevantMethod(nativeStackCallInfo.getMethodName())) continue;
                return nativeStackCallInfo;
            }
            if (this.mResolvedStackCall.size() > 0) {
                return this.mResolvedStackCall.get(0);
            }
        }
        return null;
    }

    private boolean isRelevantLibrary(String string) {
        for (String string2 : FILTERED_LIBRARIES) {
            if (!string.endsWith(string2)) continue;
            return false;
        }
        return true;
    }

    private boolean isRelevantMethod(String string) {
        for (Pattern pattern : FILTERED_METHOD_NAME_PATTERNS) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return false;
        }
        return true;
    }
}

