/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.Device;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.Log;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.utils.ArrayHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;

public final class SyncService {
    private static final byte[] ID_OKAY = new byte[]{79, 75, 65, 89};
    private static final byte[] ID_FAIL = new byte[]{70, 65, 73, 76};
    private static final byte[] ID_STAT = new byte[]{83, 84, 65, 84};
    private static final byte[] ID_RECV = new byte[]{82, 69, 67, 86};
    private static final byte[] ID_DATA = new byte[]{68, 65, 84, 65};
    private static final byte[] ID_DONE = new byte[]{68, 79, 78, 69};
    private static final byte[] ID_SEND = new byte[]{83, 69, 78, 68};
    private static final NullSyncProgresMonitor sNullSyncProgressMonitor = new NullSyncProgresMonitor();
    private static final int S_ISOCK = 49152;
    private static final int S_IFLNK = 40960;
    private static final int S_IFREG = 32768;
    private static final int S_IFBLK = 24576;
    private static final int S_IFDIR = 16384;
    private static final int S_IFCHR = 8192;
    private static final int S_IFIFO = 4096;
    private static final int SYNC_DATA_MAX = 65536;
    private static final int REMOTE_PATH_MAX_LENGTH = 1024;
    private InetSocketAddress mAddress;
    private Device mDevice;
    private SocketChannel mChannel;
    private byte[] mBuffer;

    SyncService(InetSocketAddress inetSocketAddress, Device device) {
        this.mAddress = inetSocketAddress;
        this.mDevice = device;
    }

    boolean openSync() throws TimeoutException, AdbCommandRejectedException, IOException {
        try {
            this.mChannel = SocketChannel.open(this.mAddress);
            this.mChannel.configureBlocking(false);
            AdbHelper.setDevice(this.mChannel, this.mDevice);
            byte[] byArray = AdbHelper.formAdbRequest("sync:");
            AdbHelper.write(this.mChannel, byArray, -1, DdmPreferences.getTimeOut());
            AdbHelper.AdbResponse adbResponse = AdbHelper.readAdbResponse(this.mChannel, false);
            if (!adbResponse.okay) {
                Log.w("ddms", "Got unhappy response from ADB sync req: " + adbResponse.message);
                this.mChannel.close();
                this.mChannel = null;
                return false;
            }
        }
        catch (TimeoutException timeoutException) {
            if (this.mChannel != null) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.mChannel = null;
            }
            throw timeoutException;
        }
        catch (IOException iOException) {
            if (this.mChannel != null) {
                try {
                    this.mChannel.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this.mChannel = null;
            }
            throw iOException;
        }
        return true;
    }

    public void close() {
        if (this.mChannel != null) {
            try {
                this.mChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mChannel = null;
        }
    }

    public static ISyncProgressMonitor getNullProgressMonitor() {
        return sNullSyncProgressMonitor;
    }

    public void pull(FileListingService.FileEntry[] fileEntryArray, String string, ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
        File file = new File(string);
        if (!file.exists()) {
            throw new SyncException(SyncException.SyncError.NO_DIR_TARGET);
        }
        if (!file.isDirectory()) {
            throw new SyncException(SyncException.SyncError.TARGET_IS_FILE);
        }
        FileListingService fileListingService = new FileListingService(this.mDevice);
        int n = this.getTotalRemoteFileSize(fileEntryArray, fileListingService);
        iSyncProgressMonitor.start(n);
        this.doPull(fileEntryArray, string, fileListingService, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
    }

    public void pullFile(FileListingService.FileEntry fileEntry, String string, ISyncProgressMonitor iSyncProgressMonitor) throws IOException, SyncException, TimeoutException {
        int n = fileEntry.getSizeValue();
        iSyncProgressMonitor.start(n);
        this.doPullFile(fileEntry.getFullPath(), string, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
    }

    public void pullFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws TimeoutException, IOException, SyncException {
        Integer n = this.readMode(string);
        if (n != null && n == 0) {
            throw new SyncException(SyncException.SyncError.NO_REMOTE_OBJECT);
        }
        iSyncProgressMonitor.start(0);
        this.doPullFile(string, string2, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
    }

    public void push(String[] stringArray, FileListingService.FileEntry fileEntry, ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
        if (!fileEntry.isDirectory()) {
            throw new SyncException(SyncException.SyncError.REMOTE_IS_FILE);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : stringArray) {
            arrayList.add(new File(string));
        }
        Object[] objectArray = arrayList.toArray(new File[arrayList.size()]);
        int n = this.getTotalLocalFileSize((File[])objectArray);
        iSyncProgressMonitor.start(n);
        this.doPush((File[])objectArray, fileEntry.getFullPath(), iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
    }

    public void pushFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
        File file = new File(string);
        if (!file.exists()) {
            throw new SyncException(SyncException.SyncError.NO_LOCAL_FILE);
        }
        if (file.isDirectory()) {
            throw new SyncException(SyncException.SyncError.LOCAL_IS_DIRECTORY);
        }
        iSyncProgressMonitor.start((int)file.length());
        this.doPushFile(string, string2, iSyncProgressMonitor);
        iSyncProgressMonitor.stop();
    }

    private int getTotalRemoteFileSize(FileListingService.FileEntry[] fileEntryArray, FileListingService fileListingService) {
        int n = 0;
        for (FileListingService.FileEntry fileEntry : fileEntryArray) {
            int n2 = fileEntry.getType();
            if (n2 == 1) {
                FileListingService.FileEntry[] fileEntryArray2 = fileListingService.getChildren(fileEntry, false, null);
                n += this.getTotalRemoteFileSize(fileEntryArray2, fileListingService) + 1;
                continue;
            }
            if (n2 != 0) continue;
            n += fileEntry.getSizeValue();
        }
        return n;
    }

    private int getTotalLocalFileSize(File[] fileArray) {
        int n = 0;
        for (File file : fileArray) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                return this.getTotalLocalFileSize(file.listFiles()) + 1;
            }
            if (!file.isFile()) continue;
            n = (int)((long)n + file.length());
        }
        return n;
    }

    private void doPull(FileListingService.FileEntry[] fileEntryArray, String string, FileListingService fileListingService, ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
        for (FileListingService.FileEntry fileEntry : fileEntryArray) {
            String string2;
            if (iSyncProgressMonitor.isCanceled()) {
                throw new SyncException(SyncException.SyncError.CANCELED);
            }
            int n = fileEntry.getType();
            if (n == 1) {
                iSyncProgressMonitor.startSubTask(fileEntry.getFullPath());
                string2 = string + File.separator + fileEntry.getName();
                File file = new File(string2);
                file.mkdir();
                FileListingService.FileEntry[] fileEntryArray2 = fileListingService.getChildren(fileEntry, true, null);
                this.doPull(fileEntryArray2, string2, fileListingService, iSyncProgressMonitor);
                iSyncProgressMonitor.advance(1);
                continue;
            }
            if (n != 0) continue;
            iSyncProgressMonitor.startSubTask(fileEntry.getFullPath());
            string2 = string + File.separator + fileEntry.getName();
            this.doPullFile(fileEntry.getFullPath(), string2, iSyncProgressMonitor);
        }
    }

    private void doPullFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws IOException, SyncException, TimeoutException {
        Object object;
        byte[] byArray = null;
        byte[] byArray2 = new byte[8];
        int n = DdmPreferences.getTimeOut();
        try {
            object = string.getBytes("ISO-8859-1");
            if (((byte[])object).length > 1024) {
                throw new SyncException(SyncException.SyncError.REMOTE_PATH_LENGTH);
            }
            byArray = SyncService.createFileReq(ID_RECV, (byte[])object);
            AdbHelper.write(this.mChannel, byArray, -1, n);
            AdbHelper.read(this.mChannel, byArray2, -1, n);
            if (!SyncService.checkResult(byArray2, ID_DATA) && !SyncService.checkResult(byArray2, ID_DONE)) {
                throw new SyncException(SyncException.SyncError.TRANSFER_PROTOCOL_ERROR, this.readErrorMessage(byArray2, n));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SyncException(SyncException.SyncError.REMOTE_PATH_ENCODING, (Throwable)unsupportedEncodingException);
        }
        object = new File(string2);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((File)object);
        }
        catch (IOException iOException) {
            Log.e("ddms", String.format("Failed to open local file %s for writing, Reason: %s", ((File)object).getAbsolutePath(), iOException.toString()));
            throw new SyncException(SyncException.SyncError.FILE_WRITE_ERROR);
        }
        byte[] byArray3 = new byte[65536];
        while (true) {
            if (iSyncProgressMonitor.isCanceled()) {
                throw new SyncException(SyncException.SyncError.CANCELED);
            }
            if (SyncService.checkResult(byArray2, ID_DONE)) break;
            if (!SyncService.checkResult(byArray2, ID_DATA)) {
                throw new SyncException(SyncException.SyncError.TRANSFER_PROTOCOL_ERROR, this.readErrorMessage(byArray2, n));
            }
            int n2 = ArrayHelper.swap32bitFromArray(byArray2, 4);
            if (n2 > 65536) {
                throw new SyncException(SyncException.SyncError.BUFFER_OVERRUN);
            }
            AdbHelper.read(this.mChannel, byArray3, n2, n);
            AdbHelper.read(this.mChannel, byArray2, -1, n);
            fileOutputStream.write(byArray3, 0, n2);
            iSyncProgressMonitor.advance(n2);
        }
        fileOutputStream.flush();
    }

    private void doPush(File[] fileArray, String string, ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
        for (File file : fileArray) {
            String string2;
            if (iSyncProgressMonitor.isCanceled()) {
                throw new SyncException(SyncException.SyncError.CANCELED);
            }
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                string2 = string + "/" + file.getName();
                iSyncProgressMonitor.startSubTask(string2);
                this.doPush(file.listFiles(), string2, iSyncProgressMonitor);
                iSyncProgressMonitor.advance(1);
                continue;
            }
            if (!file.isFile()) continue;
            string2 = string + "/" + file.getName();
            iSyncProgressMonitor.startSubTask(string2);
            this.doPushFile(file.getAbsolutePath(), string2, iSyncProgressMonitor);
        }
    }

    private void doPushFile(String string, String string2, ISyncProgressMonitor iSyncProgressMonitor) throws SyncException, IOException, TimeoutException {
        byte[] byArray;
        FileInputStream fileInputStream = null;
        int n = DdmPreferences.getTimeOut();
        try {
            byte[] byArray2 = string2.getBytes("ISO-8859-1");
            if (byArray2.length > 1024) {
                throw new SyncException(SyncException.SyncError.REMOTE_PATH_LENGTH);
            }
            File file = new File(string);
            fileInputStream = new FileInputStream(file);
            byArray = SyncService.createSendFileReq(ID_SEND, byArray2, 420);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SyncException(SyncException.SyncError.REMOTE_PATH_ENCODING, (Throwable)unsupportedEncodingException);
        }
        AdbHelper.write(this.mChannel, byArray, -1, n);
        if (this.mBuffer == null) {
            this.mBuffer = new byte[65544];
        }
        System.arraycopy(ID_DATA, 0, this.mBuffer, 0, ID_DATA.length);
        while (true) {
            if (iSyncProgressMonitor.isCanceled()) {
                throw new SyncException(SyncException.SyncError.CANCELED);
            }
            int n2 = fileInputStream.read(this.mBuffer, 8, 65536);
            if (n2 == -1) break;
            ArrayHelper.swap32bitsToArray(n2, this.mBuffer, 4);
            AdbHelper.write(this.mChannel, this.mBuffer, n2 + 8, n);
            iSyncProgressMonitor.advance(n2);
        }
        fileInputStream.close();
        long l = System.currentTimeMillis() / 1000L;
        byArray = SyncService.createReq(ID_DONE, (int)l);
        AdbHelper.write(this.mChannel, byArray, -1, n);
        byte[] byArray3 = new byte[8];
        AdbHelper.read(this.mChannel, byArray3, -1, n);
        if (!SyncService.checkResult(byArray3, ID_OKAY)) {
            throw new SyncException(SyncException.SyncError.TRANSFER_PROTOCOL_ERROR, this.readErrorMessage(byArray3, n));
        }
    }

    private String readErrorMessage(byte[] byArray, int n) throws TimeoutException, IOException {
        int n2;
        if (SyncService.checkResult(byArray, ID_FAIL) && (n2 = ArrayHelper.swap32bitFromArray(byArray, 4)) > 0) {
            AdbHelper.read(this.mChannel, this.mBuffer, n2, n);
            String string = new String(this.mBuffer, 0, n2);
            Log.e("ddms", "transfer error: " + string);
            return string;
        }
        return null;
    }

    private Integer readMode(String string) throws TimeoutException, IOException {
        byte[] byArray = SyncService.createFileReq(ID_STAT, string);
        AdbHelper.write(this.mChannel, byArray, -1, DdmPreferences.getTimeOut());
        byte[] byArray2 = new byte[16];
        AdbHelper.read(this.mChannel, byArray2, -1, DdmPreferences.getTimeOut());
        if (!SyncService.checkResult(byArray2, ID_STAT)) {
            return null;
        }
        return ArrayHelper.swap32bitFromArray(byArray2, 4);
    }

    private static byte[] createReq(byte[] byArray, int n) {
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        ArrayHelper.swap32bitsToArray(n, byArray2, 4);
        return byArray2;
    }

    private static byte[] createFileReq(byte[] byArray, String string) {
        byte[] byArray2 = null;
        try {
            byArray2 = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        return SyncService.createFileReq(byArray, byArray2);
    }

    private static byte[] createFileReq(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[8 + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, 4);
        ArrayHelper.swap32bitsToArray(byArray2.length, byArray3, 4);
        System.arraycopy(byArray2, 0, byArray3, 8, byArray2.length);
        return byArray3;
    }

    private static byte[] createSendFileReq(byte[] byArray, byte[] byArray2, int n) {
        String string = "," + (n & 0x1FF);
        byte[] byArray3 = null;
        try {
            byArray3 = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        byte[] byArray4 = new byte[8 + byArray2.length + byArray3.length];
        System.arraycopy(byArray, 0, byArray4, 0, 4);
        ArrayHelper.swap32bitsToArray(byArray2.length + byArray3.length, byArray4, 4);
        System.arraycopy(byArray2, 0, byArray4, 8, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, 8 + byArray2.length, byArray3.length);
        return byArray4;
    }

    private static boolean checkResult(byte[] byArray, byte[] byArray2) {
        return byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray[2] == byArray2[2] && byArray[3] == byArray2[3];
    }

    private static int getFileType(int n) {
        if ((n & 0xC000) == 49152) {
            return 6;
        }
        if ((n & 0xA000) == 40960) {
            return 5;
        }
        if ((n & 0x8000) == 32768) {
            return 0;
        }
        if ((n & 0x6000) == 24576) {
            return 3;
        }
        if ((n & 0x4000) == 16384) {
            return 1;
        }
        if ((n & 0x2000) == 8192) {
            return 4;
        }
        if ((n & 0x1000) == 4096) {
            return 7;
        }
        return 8;
    }

    private static class NullSyncProgresMonitor
    implements ISyncProgressMonitor {
        private NullSyncProgresMonitor() {
        }

        public void advance(int n) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void start(int n) {
        }

        public void startSubTask(String string) {
        }

        public void stop() {
        }
    }

    public static interface ISyncProgressMonitor {
        public void start(int var1);

        public void stop();

        public boolean isCanceled();

        public void startSubTask(String var1);

        public void advance(int var1);
    }
}

